/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.URIUtilities;
import edu.stanford.smi.protege.widget.TextComponentWidget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.JTextComponent;

public class ImageWidget
extends TextComponentWidget {
    private JLabel imageDisplay;

    public void initialize() {
        super.initialize(true, 2, 2);
    }

    protected JTextComponent createTextComponent() {
        return ComponentFactory.createTextField();
    }

    protected JComponent createCenterComponent(JTextComponent jTextComponent) {
        this.imageDisplay = ComponentFactory.createLabel();
        this.imageDisplay.setVerticalAlignment(1);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jTextComponent, "North");
        jPanel.add((Component)new JScrollPane(this.imageDisplay), "Center");
        return jPanel;
    }

    protected void onCommit() {
        super.onCommit();
        this.updateImage();
    }

    private void updateImage() {
        String string = this.getText();
        Icon icon = this.getIcon(string);
        this.imageDisplay.setIcon(icon);
    }

    private Icon getIcon(String string) {
        URL uRL = URIUtilities.toURL(string, this.getProject().getProjectURI());
        return uRL == null ? null : new ImageIcon(uRL);
    }

    protected void onSetText(String string) {
        this.updateImage();
    }
}

