/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.IntegerField;
import edu.stanford.smi.protege.widget.AbstractSlotWidget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class MaximumCardinalityWidget
extends AbstractSlotWidget {
    private JCheckBox _isMultipleComponent;
    private IntegerField _atMostComponent;
    private ActionListener _buttonListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            MaximumCardinalityWidget.this._atMostComponent.removeActionListener(MaximumCardinalityWidget.this._textFieldListener);
            if (MaximumCardinalityWidget.this._isMultipleComponent.isSelected()) {
                MaximumCardinalityWidget.this._atMostComponent.clearValue();
            } else {
                MaximumCardinalityWidget.this._atMostComponent.setValue(1);
            }
            MaximumCardinalityWidget.this._atMostComponent.addActionListener(MaximumCardinalityWidget.this._textFieldListener);
            MaximumCardinalityWidget.this.valueChanged();
        }
    };
    private ActionListener _textFieldListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            Integer n = MaximumCardinalityWidget.this._atMostComponent.getValue();
            boolean bl = n != null && n > 1;
            MaximumCardinalityWidget.this._isMultipleComponent.removeActionListener(MaximumCardinalityWidget.this._buttonListener);
            MaximumCardinalityWidget.this._isMultipleComponent.setSelected(bl);
            MaximumCardinalityWidget.this._isMultipleComponent.addActionListener(MaximumCardinalityWidget.this._buttonListener);
            MaximumCardinalityWidget.this.valueChanged();
        }
    };

    private Component createAtMostComponent() {
        String string = LocalizedText.getText(ResourceKey.AT_MOST_LABEL);
        this._atMostComponent = new IntegerField(string);
        this._atMostComponent.addActionListener(this._textFieldListener);
        JPanel jPanel = new JPanel(new FlowLayout(2, 0, 0));
        jPanel.add(this._atMostComponent);
        return jPanel;
    }

    private JComponent createIsMultipleComponent() {
        String string = LocalizedText.getText(ResourceKey.MULTIPLE_LABEL);
        this._isMultipleComponent = ComponentFactory.createCheckBox(string);
        this._isMultipleComponent.addActionListener(this._buttonListener);
        return this._isMultipleComponent;
    }

    public Collection getValues() {
        Integer n = this._atMostComponent.getValue();
        return CollectionUtilities.createCollection(n);
    }

    public void initialize() {
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        jPanel.add(this.createIsMultipleComponent());
        jPanel.add(this.createAtMostComponent());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "North");
        this.add(jPanel2);
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        return slot.getName().equals(":SLOT-MAXIMUM-CARDINALITY");
    }

    public void setEditable(boolean bl) {
        this._isMultipleComponent.setEnabled(bl);
        this._atMostComponent.setEnabled(bl);
    }

    public void setValues(Collection collection) {
        Integer n = (Integer)MaximumCardinalityWidget.getFirstItem(collection);
        boolean bl = n == null || n > 1;
        this._isMultipleComponent.removeActionListener(this._buttonListener);
        this._atMostComponent.removeActionListener(this._textFieldListener);
        this._isMultipleComponent.setSelected(bl);
        if (n == null) {
            this._atMostComponent.clearValue();
        } else {
            this._atMostComponent.setValue(n);
        }
        this._isMultipleComponent.addActionListener(this._buttonListener);
        this._atMostComponent.addActionListener(this._textFieldListener);
    }
}

