/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.widget;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.widget.SlotWidget;
import java.awt.Component;
import java.util.Comparator;

public class SlotWidgetComparer
implements Comparator {
    private static final int SINGLE = 0;
    private static final int MULTIPLE = 1;
    private static final int[][] _rank = new int[2][8];

    public int compare(Object object, Object object2) {
        SlotWidget slotWidget = (SlotWidget)object;
        SlotWidget slotWidget2 = (SlotWidget)object2;
        int n = SlotWidgetComparer.getRank(slotWidget) - SlotWidgetComparer.getRank(slotWidget2);
        if (n == 0) {
            n = ((Component)((Object)slotWidget)).getHeight() - ((Component)((Object)slotWidget2)).getHeight();
        }
        if (n == 0) {
            String string = slotWidget.getLabel();
            String string2 = slotWidget2.getLabel();
            if (string == null || string2 == null) {
                Log.getLogger().warning("null label: " + object + " " + object2);
                n = 0;
            } else {
                n = string.compareToIgnoreCase(string2);
            }
        }
        return n;
    }

    private static int getRank(SlotWidget slotWidget) {
        Cls cls = slotWidget.getCls();
        Slot slot = slotWidget.getSlot();
        boolean bl = cls.getTemplateSlotAllowsMultipleValues(slot);
        ValueType valueType = cls.getTemplateSlotValueType(slot);
        return _rank[bl ? 1 : 0][valueType.getIntValue()];
    }

    static {
        SlotWidgetComparer._rank[0][ValueType.ANY.getIntValue()] = 10;
        SlotWidgetComparer._rank[0][ValueType.BOOLEAN.getIntValue()] = 1;
        SlotWidgetComparer._rank[0][ValueType.CLS.getIntValue()] = 5;
        SlotWidgetComparer._rank[0][ValueType.FLOAT.getIntValue()] = 3;
        SlotWidgetComparer._rank[0][ValueType.INSTANCE.getIntValue()] = 6;
        SlotWidgetComparer._rank[0][ValueType.INTEGER.getIntValue()] = 2;
        SlotWidgetComparer._rank[0][ValueType.STRING.getIntValue()] = 0;
        SlotWidgetComparer._rank[0][ValueType.SYMBOL.getIntValue()] = 4;
        SlotWidgetComparer._rank[1][ValueType.ANY.getIntValue()] = 11;
        SlotWidgetComparer._rank[1][ValueType.BOOLEAN.getIntValue()] = 7;
        SlotWidgetComparer._rank[1][ValueType.CLS.getIntValue()] = 8;
        SlotWidgetComparer._rank[1][ValueType.FLOAT.getIntValue()] = 7;
        SlotWidgetComparer._rank[1][ValueType.INSTANCE.getIntValue()] = 9;
        SlotWidgetComparer._rank[1][ValueType.INTEGER.getIntValue()] = 7;
        SlotWidgetComparer._rank[1][ValueType.STRING.getIntValue()] = 7;
        SlotWidgetComparer._rank[1][ValueType.SYMBOL.getIntValue()] = 7;
    }
}

