/*
 * Decompiled with CFR 0.152.
 */
package org.daml.kazuki;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceRequiredException;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.util.iterator.Filter;
import com.hp.hpl.jena.util.iterator.Map1;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.daml.kazuki.Datatypes;
import org.daml.kazuki.JavaUtil;

public class ModelUtil {
    private static Set reservedWords = new HashSet();
    private static String[] JenaWords = new String[]{"SameIndividualAs", "Comment", "DifferentFrom", "IsDefinedBy", "Label", "RDFType", "SameAs", "SeeAlso", "VersionInfo", "Cardinality", "Profile", "PropertyValue", "Property", "Id", "LocalName", "Model", "NameSpace", "Node", "RequiredProperty", "URI", "All"};
    public static boolean DEBUG;
    public static final int FULL = 0;
    public static final int DL = 1;
    public static final int LITE = 2;
    public static int OWL_SPECIES;
    public static final Filter nullFilter;
    public static final Map1 objectAsResourceMapper;
    public static final Map1 objectAsStringMapper;
    public static final Map1 objectAsBigIntegerMapper;
    public static final Map1 objectAsBigDecimalMapper;
    public static final Map1 objectAsFloatMapper;
    public static final Map1 objectAsIntegerMapper;
    public static final Map1 objectAsCalendarMapper;
    public static final Map1 objectAsDoubleMapper;
    public static final Map1 objectAsLongMapper;
    public static final Map1 objectAsShortMapper;
    public static final Map1 objectAsBooleanMapper;
    public static final Map1 objectAsCharacterMapper;
    public static final Map1 objectAsByteMapper;

    public static Iterator listOWLClasses(Model model) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ResIterator resIterator = model.listSubjectsWithProperty(RDF.type, (RDFNode)OWL.Class);
        while (resIterator.hasNext()) {
            arrayList.add(resIterator.next());
        }
        resIterator.close();
        resIterator = model.listSubjectsWithProperty(RDF.type, (RDFNode)RDFS.Class);
        while (resIterator.hasNext()) {
            arrayList.add(resIterator.next());
        }
        resIterator.close();
        return arrayList.iterator();
    }

    public static Iterator getDefinedProperties(Resource resource) {
        ArrayList<Resource> arrayList = new ArrayList<Resource>();
        ResIterator resIterator = resource.getModel().listSubjectsWithProperty(RDFS.domain, (RDFNode)resource);
        while (resIterator.hasNext()) {
            Resource resource2 = resIterator.nextResource();
            if (DEBUG) {
                System.out.println(resource2);
            }
            arrayList.add(resource2);
        }
        resIterator.close();
        return arrayList.iterator();
    }

    public static Iterator getSuperClasses(Resource resource) {
        ArrayList<Resource> arrayList = new ArrayList<Resource>();
        NodeIterator nodeIterator = resource.getModel().listObjectsOfProperty(resource, RDFS.subClassOf);
        while (nodeIterator.hasNext()) {
            RDFNode rDFNode = nodeIterator.nextNode();
            if (!(rDFNode instanceof Resource)) continue;
            arrayList.add((Resource)rDFNode);
        }
        nodeIterator.close();
        return arrayList.iterator();
    }

    private static boolean isClass(Resource resource) {
        return resource.hasProperty(RDF.type, (RDFNode)OWL.Class) || resource.hasProperty(RDF.type, (RDFNode)RDFS.Class);
    }

    public static boolean isRestriction(Resource resource) {
        return resource.hasProperty(RDF.type, (RDFNode)OWL.Restriction);
    }

    public static boolean isDatatypeProperty(Resource resource) {
        return resource.hasProperty(RDF.type, (RDFNode)OWL.DatatypeProperty);
    }

    public static boolean isObjectProperty(Resource resource) {
        return resource.hasProperty(RDF.type, (RDFNode)OWL.ObjectProperty) || OWL_SPECIES == 0 && resource.hasProperty(RDF.type, (RDFNode)RDF.Property);
    }

    public static String StringForResource(Resource[] resourceArray, String[] stringArray, Resource resource) {
        int n = 0;
        while (n < resourceArray.length) {
            if (resource.equals((Object)resourceArray[n])) {
                return stringArray[n];
            }
            ++n;
        }
        return null;
    }

    public static Resource ResourceForString(Resource[] resourceArray, String[] stringArray, String string) {
        int n = 0;
        while (n < stringArray.length) {
            if (string.equalsIgnoreCase(stringArray[n])) {
                return resourceArray[n];
            }
            ++n;
        }
        return null;
    }

    public static String makePropertyName(String string, String string2) {
        String string3 = JavaUtil.makeJavaValidName(JavaUtil.capitalize(string2));
        if (reservedWords.contains(string3)) {
            string3 = "_" + string3;
        }
        return JavaUtil.makeJavaValidName(string + string3);
    }

    static {
        int n = 0;
        while (n < JenaWords.length) {
            reservedWords.add(JenaWords[n]);
            ++n;
        }
        DEBUG = true;
        OWL_SPECIES = 0;
        nullFilter = new NullFilter();
        objectAsResourceMapper = new ObjectAsResourceMapper();
        objectAsStringMapper = new ObjectAsStringMapper();
        objectAsBigIntegerMapper = new ObjectAsBigIntegerMapper();
        objectAsBigDecimalMapper = new ObjectAsBigDecimalMapper();
        objectAsFloatMapper = new ObjectAsFloatMapper();
        objectAsIntegerMapper = new ObjectAsIntegerMapper();
        objectAsCalendarMapper = new ObjectAsCalendarMapper();
        objectAsDoubleMapper = new ObjectAsDoubleMapper();
        objectAsLongMapper = new ObjectAsLongMapper();
        objectAsShortMapper = new ObjectAsShortMapper();
        objectAsBooleanMapper = new ObjectAsBooleanMapper();
        objectAsCharacterMapper = new ObjectAsCharacterMapper();
        objectAsByteMapper = new ObjectAsByteMapper();
    }

    protected static class ObjectAsByteMapper
    implements Map1 {
        protected ObjectAsByteMapper() {
        }

        public Object map1(Object object) {
            try {
                Literal literal = ((Statement)object).getLiteral();
                return Datatypes.getByte(literal);
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    protected static class ObjectAsCharacterMapper
    implements Map1 {
        protected ObjectAsCharacterMapper() {
        }

        public Object map1(Object object) {
            try {
                Literal literal = ((Statement)object).getLiteral();
                return Datatypes.getCharacter(literal);
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    protected static class ObjectAsBooleanMapper
    implements Map1 {
        protected ObjectAsBooleanMapper() {
        }

        public Object map1(Object object) {
            try {
                Literal literal = ((Statement)object).getLiteral();
                return Datatypes.getBoolean(literal);
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    protected static class ObjectAsShortMapper
    implements Map1 {
        protected ObjectAsShortMapper() {
        }

        public Object map1(Object object) {
            try {
                Literal literal = ((Statement)object).getLiteral();
                return Datatypes.getShort(literal);
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    protected static class ObjectAsLongMapper
    implements Map1 {
        protected ObjectAsLongMapper() {
        }

        public Object map1(Object object) {
            try {
                Literal literal = ((Statement)object).getLiteral();
                return Datatypes.getLong(literal);
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    protected static class ObjectAsDoubleMapper
    implements Map1 {
        protected ObjectAsDoubleMapper() {
        }

        public Object map1(Object object) {
            try {
                Literal literal = ((Statement)object).getLiteral();
                return Datatypes.getDouble(literal);
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    protected static class ObjectAsCalendarMapper
    implements Map1 {
        protected ObjectAsCalendarMapper() {
        }

        public Object map1(Object object) {
            try {
                Literal literal = ((Statement)object).getLiteral();
                return Datatypes.getCalendar(literal);
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    protected static class ObjectAsIntegerMapper
    implements Map1 {
        protected ObjectAsIntegerMapper() {
        }

        public Object map1(Object object) {
            try {
                Literal literal = ((Statement)object).getLiteral();
                return Datatypes.getInteger(literal);
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    protected static class ObjectAsFloatMapper
    implements Map1 {
        protected ObjectAsFloatMapper() {
        }

        public Object map1(Object object) {
            try {
                Literal literal = ((Statement)object).getLiteral();
                return Datatypes.getFloat(literal);
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    protected static class ObjectAsBigDecimalMapper
    implements Map1 {
        protected ObjectAsBigDecimalMapper() {
        }

        public Object map1(Object object) {
            try {
                Literal literal = ((Statement)object).getLiteral();
                return Datatypes.getBigDecimal(literal);
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    protected static class ObjectAsBigIntegerMapper
    implements Map1 {
        protected ObjectAsBigIntegerMapper() {
        }

        public Object map1(Object object) {
            try {
                Literal literal = ((Statement)object).getLiteral();
                return Datatypes.getBigInteger(literal);
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    protected static class ObjectAsStringMapper
    implements Map1 {
        protected ObjectAsStringMapper() {
        }

        public Object map1(Object object) {
            return object instanceof Statement ? ((Statement)object).getString() : null;
        }
    }

    protected static class ObjectAsResourceMapper
    implements Map1 {
        protected ObjectAsResourceMapper() {
        }

        public Object map1(Object object) {
            try {
                if (object instanceof Statement) {
                    return ((Statement)object).getResource();
                }
            }
            catch (ResourceRequiredException resourceRequiredException) {
                System.err.println((Object)resourceRequiredException);
            }
            return null;
        }
    }

    protected static class NullFilter
    implements Filter {
        protected NullFilter() {
        }

        public boolean accept(Object object) {
            return object == null;
        }
    }
}

