/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.test;

import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPProgressMonitor;
import com.enterprisedt.net.ftp.FTPTransferType;
import com.enterprisedt.net.ftp.test.FTPTestCase;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestResume
extends FTPTestCase {
    public static String cvsId = "@(#)$Id: TestResume.java,v 1.4 2005/07/15 17:30:06 bruceb Exp $";
    static /* synthetic */ Class class$com$enterprisedt$net$ftp$test$TestResume;

    protected String getLogName() {
        return "TestResume.log";
    }

    public void testResumePut() throws Exception {
        this.log.debug("testResumePut()");
        this.connect();
        this.ftp.chdir(this.testdir);
        this.ftp.setType(FTPTransferType.BINARY);
        String filename = this.generateRandomFilename();
        this.ftp.setProgressMonitor(new CancelProgressMonitor((FTPClient)this.ftp), 4096L);
        this.ftp.put(String.valueOf(this.localDataDir) + this.localBinaryFile, filename);
        ((FTPClient)this.ftp).resume();
        this.ftp.put(String.valueOf(this.localDataDir) + this.localBinaryFile, filename);
        this.ftp.get(String.valueOf(this.localDataDir) + filename, filename);
        this.assertIdentical(String.valueOf(this.localDataDir) + this.localBinaryFile, String.valueOf(this.localDataDir) + filename);
        ((FTPClient)this.ftp).cancelResume();
        this.ftp.get(String.valueOf(this.localDataDir) + filename, filename);
        this.ftp.delete(filename);
        File local = new File(String.valueOf(this.localDataDir) + filename);
        local.delete();
        this.ftp.quit();
    }

    public void testResumeGet() throws Exception {
        this.log.debug("testResumeGet()");
        this.connect();
        this.ftp.chdir(this.testdir);
        this.ftp.setType(FTPTransferType.BINARY);
        String filename = this.generateRandomFilename();
        this.ftp.setProgressMonitor(new CancelProgressMonitor((FTPClient)this.ftp), 4096L);
        this.ftp.get(String.valueOf(this.localDataDir) + filename, this.remoteBinaryFile);
        ((FTPClient)this.ftp).resume();
        this.ftp.get(String.valueOf(this.localDataDir) + filename, this.remoteBinaryFile);
        String filename2 = this.generateRandomFilename();
        this.ftp.get(String.valueOf(this.localDataDir) + filename2, this.remoteBinaryFile);
        this.assertIdentical(String.valueOf(this.localDataDir) + filename, String.valueOf(this.localDataDir) + filename2);
        File local = new File(String.valueOf(this.localDataDir) + filename);
        local.delete();
        local = new File(String.valueOf(this.localDataDir) + filename2);
        local.delete();
        this.ftp.quit();
    }

    public static Test suite() {
        return new TestSuite(class$com$enterprisedt$net$ftp$test$TestResume != null ? class$com$enterprisedt$net$ftp$test$TestResume : (class$com$enterprisedt$net$ftp$test$TestResume = FTPTestCase.class$("com.enterprisedt.net.ftp.test.TestResume")));
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestResume.suite());
    }

    class CancelProgressMonitor
    implements FTPProgressMonitor {
        private boolean cancelled = false;
        private FTPClient ftpClient;

        public CancelProgressMonitor(FTPClient ftp) {
            TestResume.this = TestResume.this;
            this.ftpClient = ftp;
        }

        public void bytesTransferred(long bytes) {
            if (!this.cancelled) {
                this.ftpClient.cancelTransfer();
                this.cancelled = true;
            }
        }
    }
}

