/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.javacode;

import edu.stanford.smi.protegex.owl.javacode.RDFSClassCode;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;

public class RDFPropertyAtClassCode
implements Comparable {
    private RDFSNamedClass cls;
    private RDFProperty property;

    public RDFPropertyAtClassCode(RDFSNamedClass cls, RDFProperty property) {
        this.cls = cls;
        this.property = property;
    }

    public int compareTo(Object o) {
        if (o instanceof RDFPropertyAtClassCode) {
            RDFPropertyAtClassCode other = (RDFPropertyAtClassCode)o;
            return this.getJavaName().compareTo(other.getJavaName());
        }
        return 0;
    }

    public String getJavaName() {
        return RDFSClassCode.getValidJavaName(this.property.getLocalName());
    }

    public String getJavaType() {
        RDFResource range = ((OWLNamedClass)this.cls).getAllValuesFrom(this.property);
        if (range instanceof RDFSDatatype) {
            OWLModel owlModel = this.cls.getOWLModel();
            if (owlModel.getXSDboolean().equals(range)) {
                return "boolean";
            }
            if (owlModel.getXSDfloat().equals(range)) {
                return "float";
            }
            if (owlModel.getXSDint().equals(range)) {
                return "int";
            }
            if (owlModel.getXSDstring().equals(range)) {
                return "String";
            }
            return "RDFSLiteral";
        }
        if (range instanceof RDFSNamedClass) {
            return new RDFSClassCode((RDFSNamedClass)range).getJavaName();
        }
        return "Object";
    }

    public RDFProperty getRDFProperty() {
        return this.property;
    }

    public String getUpperCaseJavaName() {
        String name = this.getJavaName();
        if (name.length() > 1) {
            return String.valueOf(Character.toUpperCase(name.charAt(0))) + name.substring(1);
        }
        return name.toUpperCase();
    }

    public boolean isCustomType() {
        RDFResource range = ((OWLNamedClass)this.cls).getAllValuesFrom(this.property);
        return range instanceof RDFSNamedClass;
    }

    public boolean isMultiple() {
        if (this.cls instanceof OWLNamedClass) {
            int max = ((OWLNamedClass)this.cls).getMaxCardinality(this.property);
            return max < 0 || max > 1;
        }
        return !this.property.isFunctional();
    }

    public boolean isPrimitive() {
        OWLModel owlModel;
        RDFResource range = ((OWLNamedClass)this.cls).getAllValuesFrom(this.property);
        return range instanceof RDFSDatatype && ((owlModel = this.cls.getOWLModel()).getXSDboolean().equals(range) || owlModel.getXSDfloat().equals(range) || owlModel.getXSDint().equals(range));
    }
}

