/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.graph;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.graph.Capabilities;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphEventManager;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.GraphBase;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.graph.query.QueryHandler;
import com.hp.hpl.jena.graph.query.SimpleQueryHandler;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.shared.AddDeniedException;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NullIterator;
import com.hp.hpl.jena.util.iterator.SingletonIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import edu.stanford.smi.protegex.owl.jena.graph.ProtegeCapabilities;
import edu.stanford.smi.protegex.owl.jena.graph.ProtegePrefixMapping;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFObject;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.impl.XMLSchemaDatatypes;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ProtegeGraph
extends GraphBase
implements Graph {
    private Capabilities capabilities = new ProtegeCapabilities();
    private OWLModel owlModel;
    private PrefixMapping prefixMapping;
    private TripleStore ts;

    public ProtegeGraph(OWLModel owlModel, TripleStore ts) {
        this.owlModel = owlModel;
        this.ts = ts;
        this.prefixMapping = new ProtegePrefixMapping(owlModel, ts);
    }

    public void add(Triple triple) throws AddDeniedException {
        throw new RuntimeException("Not supported yet");
    }

    public void close() {
    }

    private ExtendedIterator createExtendedIterator(Iterator protegeTriplesIterator) {
        List results = this.createJenaTriplesList(protegeTriplesIterator);
        return WrappedIterator.create(results.iterator());
    }

    private List createJenaTriplesList(Iterator protegeTriplesIterator) {
        ArrayList<Triple> results = new ArrayList<Triple>();
        while (protegeTriplesIterator.hasNext()) {
            edu.stanford.smi.protegex.owl.model.triplestore.Triple triple = (edu.stanford.smi.protegex.owl.model.triplestore.Triple)protegeTriplesIterator.next();
            Node subjectNode = this.createNode(triple.getSubject());
            Node predicateNode = this.createNode(triple.getPredicate());
            Node objectNode = this.createNode(triple.getObject());
            results.add(new Triple(subjectNode, predicateNode, objectNode));
        }
        return results;
    }

    private Node createNode(Object object) {
        if (object instanceof RDFResource) {
            RDFResource resource = (RDFResource)object;
            if (resource.isAnonymous()) {
                return Node.createAnon((AnonId)new AnonId(resource.getName()));
            }
            return Node.createURI((String)resource.getURI());
        }
        if (!(object instanceof RDFSLiteral)) {
            object = this.owlModel.createRDFSLiteral(object);
        }
        RDFSLiteral literal = (RDFSLiteral)object;
        String lang = literal.getLanguage();
        String lex = literal.toString();
        if (lang != null) {
            RDFDatatype rdfDatatype = this.getRDFDatatype(this.owlModel.getXSDstring());
            return Node.createLiteral((String)lex, (String)lang, (RDFDatatype)rdfDatatype);
        }
        RDFDatatype datatype = this.getRDFDatatype(literal.getDatatype());
        return Node.createLiteral((String)lex, null, (RDFDatatype)datatype);
    }

    private RDFSLiteral createRDFSLiteral(LiteralLabel literalLabel) {
        String datatypeURI = literalLabel.getDatatypeURI();
        if (datatypeURI == null) {
            String value = literalLabel.getLexicalForm();
            return this.owlModel.createRDFSLiteral(value, this.owlModel.getXSDstring());
        }
        RDFSDatatype datatype = this.owlModel.getRDFSDatatypeByURI(datatypeURI);
        String value = literalLabel.getLexicalForm();
        return this.owlModel.createRDFSLiteral(value, datatype);
    }

    public boolean dependsOn(Graph graph) {
        return false;
    }

    private ExtendedIterator findAllTriples() {
        Iterator it = this.ts.listTriples();
        return this.createExtendedIterator(it);
    }

    private ExtendedIterator findWithObjectOnly(Node objectNode) {
        RDFObject object = this.getRDFObject(objectNode);
        if (object == null) {
            return new NullIterator();
        }
        return this.createExtendedIterator(this.ts.listTriplesWithObject(object));
    }

    private ExtendedIterator findWithPredicateOnly(Node predicateNode) {
        RDFProperty property = this.getRDFProperty(predicateNode);
        if (property != null) {
            ArrayList<Triple> results = new ArrayList<Triple>();
            Iterator it = this.ts.listSubjects(property);
            while (it.hasNext()) {
                RDFResource subject = (RDFResource)it.next();
                Node subjectNode = this.createNode(subject);
                Iterator vit = subject.listPropertyValues(property);
                while (vit.hasNext()) {
                    Object value = vit.next();
                    Node objectNode = this.createNode(value);
                    results.add(new Triple(subjectNode, predicateNode, objectNode));
                }
            }
            return WrappedIterator.create(results.iterator());
        }
        return new NullIterator();
    }

    private ExtendedIterator findWithPredicateAndObject(Node predicateNode, Node objectNode) {
        RDFObject object;
        RDFProperty predicate = this.getRDFProperty(predicateNode);
        if (predicate != null && (object = this.getRDFObject(objectNode)) != null) {
            ArrayList<Triple> results = new ArrayList<Triple>();
            Iterator it = this.ts.listSubjects(predicate, object);
            while (it.hasNext()) {
                RDFResource subject = (RDFResource)it.next();
                Node subjectNode = this.createNode(subject);
                Triple triple = new Triple(subjectNode, predicateNode, objectNode);
                results.add(triple);
            }
            return WrappedIterator.create(results.iterator());
        }
        return new NullIterator();
    }

    private ExtendedIterator findWithSubject(Node subjectNode, RDFResource subject, Node predicateNode, Node objectNode) {
        if (predicateNode != null) {
            String predicateName = this.getResourceName(predicateNode);
            if (predicateName == null) {
                return new NullIterator();
            }
            RDFResource predicate = this.owlModel.getRDFResource(predicateName);
            if (predicate instanceof RDFProperty) {
                return this.findWithSubjectAndPredicate(subjectNode, subject, predicateNode, (RDFProperty)predicate, objectNode);
            }
            return new NullIterator();
        }
        if (objectNode != null) {
            return this.findWithSubjectAndObject(subjectNode, subject, objectNode);
        }
        return this.findWithSubjectOnly(subjectNode, subject);
    }

    private ExtendedIterator findWithSubjectOnly(Node subjectNode, RDFResource subject) {
        ArrayList<Triple> results = new ArrayList<Triple>();
        Iterator it = this.ts.listTriples();
        while (it.hasNext()) {
            edu.stanford.smi.protegex.owl.model.triplestore.Triple triple = (edu.stanford.smi.protegex.owl.model.triplestore.Triple)it.next();
            if (!triple.getSubject().equals(subject)) continue;
            Node predicateNode = this.createNode(triple.getPredicate());
            Node objectNode = this.createNode(triple.getObject());
            results.add(new Triple(subjectNode, predicateNode, objectNode));
        }
        return WrappedIterator.create(results.iterator());
    }

    private ExtendedIterator findWithSubjectAndObject(Node subjectNode, RDFResource subject, Node objectNode) {
        ArrayList<Triple> results = new ArrayList<Triple>();
        Iterator it = this.ts.listTriples();
        while (it.hasNext()) {
            Node otherObjectNode;
            edu.stanford.smi.protegex.owl.model.triplestore.Triple triple = (edu.stanford.smi.protegex.owl.model.triplestore.Triple)it.next();
            if (!triple.getSubject().equals(subject) || !(otherObjectNode = this.createNode(triple.getObject())).equals((Object)objectNode)) continue;
            Node predicateNode = this.createNode(triple.getPredicate());
            results.add(new Triple(subjectNode, predicateNode, objectNode));
        }
        return WrappedIterator.create(results.iterator());
    }

    private ExtendedIterator findWithSubjectAndPredicate(Node subjectNode, RDFResource subject, Node predicateNode, RDFProperty predicate, Node objectNode) {
        if (objectNode != null) {
            RDFObject object = null;
            if (objectNode.isLiteral()) {
                object = this.createRDFSLiteral(objectNode.getLiteral());
            } else {
                object = this.getRDFResource(objectNode);
                if (object == null) {
                    return new NullIterator();
                }
            }
            if (this.ts.contains(subject, predicate, object)) {
                return new SingletonIterator((Object)new Triple(subjectNode, predicateNode, objectNode));
            }
            return new NullIterator();
        }
        ArrayList<Triple> triples = new ArrayList<Triple>();
        Iterator it = this.ts.listObjects(subject, predicate);
        while (it.hasNext()) {
            Object object = it.next();
            Node node = this.createNode(object);
            triples.add(new Triple(subjectNode, predicateNode, node));
        }
        return WrappedIterator.create(triples.iterator());
    }

    private RDFDatatype getRDFDatatype(RDFSDatatype datatype) {
        return XMLSchemaDatatypes.getRDFDatatype(datatype);
    }

    private RDFObject getRDFObject(Node objectNode) {
        RDFObject object = null;
        object = objectNode.isLiteral() ? this.createRDFSLiteral(objectNode.getLiteral()) : this.getRDFResource(objectNode);
        return object;
    }

    private RDFProperty getRDFProperty(Node predicateNode) {
        RDFResource resource = this.getRDFResource(predicateNode);
        if (resource instanceof RDFProperty) {
            return (RDFProperty)resource;
        }
        return null;
    }

    private RDFResource getRDFResource(Node node) {
        String name = this.getResourceName(node);
        if (name == null) {
            return null;
        }
        return this.owlModel.getRDFResource(name);
    }

    public Capabilities getCapabilities() {
        return this.capabilities;
    }

    public GraphEventManager getEventManager() {
        return null;
    }

    public PrefixMapping getPrefixMapping() {
        return this.prefixMapping;
    }

    private String getResourceName(Node node) {
        if (node.isBlank()) {
            return node.getBlankNodeId().toString();
        }
        String uri = node.getURI();
        return this.owlModel.getResourceNameForURI(uri);
    }

    protected ExtendedIterator graphBaseFind(TripleMatch tripleMatch) {
        Node subjectNode = tripleMatch.getMatchSubject();
        Node predicateNode = tripleMatch.getMatchPredicate();
        Node objectNode = tripleMatch.getMatchObject();
        if (subjectNode != null) {
            RDFResource subject = this.getRDFResource(subjectNode);
            if (subject == null) {
                return new NullIterator();
            }
            return this.findWithSubject(subjectNode, subject, predicateNode, objectNode);
        }
        if (predicateNode != null) {
            if (objectNode != null) {
                return this.findWithPredicateAndObject(predicateNode, objectNode);
            }
            return this.findWithPredicateOnly(predicateNode);
        }
        if (objectNode != null) {
            return this.findWithObjectOnly(objectNode);
        }
        return this.findAllTriples();
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean isIsomorphicWith(Graph graph) {
        return false;
    }

    public QueryHandler queryHandler() {
        return new SimpleQueryHandler((Graph)this);
    }
}

