/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.graph.tests;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import edu.stanford.smi.protegex.owl.jena.graph.JenaModelFactory;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;

public class QueryTestCase
extends AbstractJenaTestCase {
    public void testLowLevelQuery() throws Exception {
        OWLNamedClass personClass = this.owlModel.createOWLNamedClass("Person");
        OWLDatatypeProperty property = this.owlModel.createOWLDatatypeProperty("hasName");
        RDFResource instance = personClass.createInstance("instance");
        instance.addPropertyValue(property, "Test");
        String queryString = "PREFIX : <" + this.owlModel.getNamespaceManager().getDefaultNamespace() + ">" + "SELECT ?person ?name WHERE { ?person :hasName ?name }";
        Query query = QueryFactory.create((String)queryString);
        Model model = JenaModelFactory.createModel(this.owlModel);
        QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Model)model);
        ResultSet results = qexec.execSelect();
        QueryTestCase.assertTrue((boolean)results.hasNext());
        while (results.hasNext()) {
            QuerySolution soln = results.nextSolution();
            RDFNode personNode = soln.get("person");
            RDFNode nameNode = soln.get("name");
            QueryTestCase.assertEquals((String)instance.getURI(), (String)personNode.toString());
            QueryTestCase.assertEquals((String)("Test^^" + this.owlModel.getXSDstring().getURI()), (String)nameNode.toString());
        }
        QueryTestCase.assertFalse((boolean)results.hasNext());
        qexec.close();
    }

    public void testLowLevelStringQuery() throws Exception {
        OWLNamedClass personClass = this.owlModel.createOWLNamedClass("Person");
        OWLDatatypeProperty property = this.owlModel.createOWLDatatypeProperty("hasName");
        RDFResource instance = personClass.createInstance("instance");
        instance.addPropertyValue(property, "Test");
        String queryString = "PREFIX : <" + this.owlModel.getNamespaceManager().getDefaultNamespace() + ">" + "SELECT ?person ?name WHERE { ?person :hasName \"Test\" }";
        Query query = QueryFactory.create((String)queryString);
        Model model = JenaModelFactory.createModel(this.owlModel);
        QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Model)model);
        ResultSet results = qexec.execSelect();
        QueryTestCase.assertTrue((boolean)results.hasNext());
        QuerySolution soln = results.nextSolution();
        RDFNode personNode = soln.get("person");
        QueryTestCase.assertEquals((String)instance.getURI(), (String)personNode.toString());
        QueryTestCase.assertFalse((boolean)results.hasNext());
        qexec.close();
    }
}

