/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.triplestore.tests;

import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.triplestore.Triple;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.DefaultTriple;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import java.util.Iterator;

public class ListTriplesTestCase
extends AbstractJenaTestCase {
    public static final int DEFAULT_SIZE = 1;

    public void testDefaultTriples() {
        TripleStore ts = this.owlModel.getTripleStoreModel().getActiveTripleStore();
        ListTriplesTestCase.assertSize(1, ts.listTriples());
        Triple triple = (Triple)ts.listTriples().next();
        ListTriplesTestCase.assertEquals((Object)this.owlModel.getDefaultOWLOntology(), (Object)triple.getSubject());
        ListTriplesTestCase.assertEquals((Object)this.owlModel.getRDFTypeProperty(), (Object)triple.getPredicate());
        ListTriplesTestCase.assertEquals((Object)this.owlModel.getOWLOntologyClass(), (Object)triple.getObject());
    }

    public void testOWLNamedClass() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Class");
        TripleStore ts = this.owlModel.getTripleStoreModel().getActiveTripleStore();
        ListTriplesTestCase.assertSize(3, ts.listTriples());
        ListTriplesTestCase.assertTrue((boolean)ts.contains(cls, this.owlModel.getRDFTypeProperty(), this.owlModel.getOWLNamedClassClass()));
        ListTriplesTestCase.assertTrue((boolean)ts.contains(cls, this.owlModel.getRDFSSubClassOfProperty(), this.owlModel.getOWLThingClass()));
    }

    public void testClassificationResultsSuppressed() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Class");
        cls.setClassificationStatus(2);
        TripleStore ts = this.owlModel.getTripleStoreModel().getActiveTripleStore();
        ListTriplesTestCase.assertSize(3, ts.listTriples());
        ListTriplesTestCase.assertTrue((boolean)ts.contains(cls, this.owlModel.getRDFTypeProperty(), this.owlModel.getOWLNamedClassClass()));
        ListTriplesTestCase.assertTrue((boolean)ts.contains(cls, this.owlModel.getRDFSSubClassOfProperty(), this.owlModel.getOWLThingClass()));
        ListTriplesTestCase.assertTrue((boolean)ts.contains(this.owlModel.getDefaultOWLOntology(), this.owlModel.getRDFTypeProperty(), this.owlModel.getOWLOntologyClass()));
    }

    public void testAddSuperclassRelationship() throws Exception {
        this.loadRemoteOntology("importTravel.owl");
        OWLNamedClass sup = this.owlModel.getOWLNamedClass("travel:Contact");
        OWLNamedClass sub = this.owlModel.getOWLNamedClass("travel:Activity");
        sub.addSuperclass(sup);
        TripleStore ts = this.owlModel.getTripleStoreModel().getActiveTripleStore();
        Iterator triples = ts.listTriples();
        ListTriplesTestCase.assertSize(5, triples);
        ListTriplesTestCase.assertTrue((boolean)ts.contains(sub, this.owlModel.getRDFSSubClassOfProperty(), sup));
    }

    public void testListTriplesWithObject() {
        RDFProperty property = this.owlModel.createRDFProperty("property");
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Class");
        cls.addPropertyValue(property, cls);
        Iterator it = this.owlModel.getTripleStoreModel().getActiveTripleStore().listTriplesWithObject(cls);
        ListTriplesTestCase.assertEquals((Object)new DefaultTriple(cls, property, cls), it.next());
        ListTriplesTestCase.assertFalse((boolean)it.hasNext());
    }
}

