/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.classparser.compact.tests;

import edu.stanford.smi.protegex.owl.model.OWLHasValue;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.classparser.OWLClassParser;
import edu.stanford.smi.protegex.owl.model.classparser.compact.CompactOWLClassParser;
import edu.stanford.smi.protegex.owl.tests.AbstractOWLModelTestCase;
import edu.stanford.smi.protegex.owl.ui.profiles.OWLProfiles;
import edu.stanford.smi.protegex.owl.ui.profiles.ProfilesManager;

public class ParseHasValueRestrictionsTestCase
extends AbstractOWLModelTestCase {
    private OWLClassParser parser = new CompactOWLClassParser();

    public void testParseHasValueBoolean() throws Exception {
        this.owlModel.createOWLDatatypeProperty("rich", this.owlModel.getXSDboolean());
        String expression = "rich $ true";
        RDFSClass aClass = this.parser.parseClass(this.owlModel, expression);
        ParseHasValueRestrictionsTestCase.assertTrue((boolean)(aClass instanceof OWLHasValue));
        OWLHasValue restriction = (OWLHasValue)aClass;
        ParseHasValueRestrictionsTestCase.assertEquals((String)restriction.getOnProperty().getName(), (String)"rich");
        ParseHasValueRestrictionsTestCase.assertEquals((Object)restriction.getHasValue(), (Object)Boolean.TRUE);
    }

    public void testParseHasValueString() throws Exception {
        this.owlModel.createOWLDatatypeProperty("name", this.owlModel.getXSDstring());
        String expression = "name $ \"Hans Eichel\"";
        RDFSClass aClass = this.parser.parseClass(this.owlModel, expression);
        ParseHasValueRestrictionsTestCase.assertTrue((boolean)(aClass instanceof OWLHasValue));
        OWLHasValue restriction = (OWLHasValue)aClass;
        ParseHasValueRestrictionsTestCase.assertEquals((String)restriction.getOnProperty().getName(), (String)"name");
        ParseHasValueRestrictionsTestCase.assertEquals((Object)restriction.getHasValue(), (Object)"Hans Eichel");
    }

    public void testParseHasClassInOWLFull() throws Exception {
        ProfilesManager.setProfile(this.owlModel, OWLProfiles.OWL_Full.getURI());
        OWLNamedClass namedCls = this.owlModel.createOWLNamedClass("Cls");
        this.owlModel.createOWLObjectProperty("slot");
        String expression = "slot $ Cls";
        RDFSClass aClass = this.parser.parseClass(this.owlModel, expression);
        ParseHasValueRestrictionsTestCase.assertTrue((boolean)(aClass instanceof OWLHasValue));
        OWLHasValue restriction = (OWLHasValue)aClass;
        ParseHasValueRestrictionsTestCase.assertEquals((String)restriction.getOnProperty().getName(), (String)"slot");
        ParseHasValueRestrictionsTestCase.assertEquals((Object)restriction.getHasValue(), (Object)namedCls);
    }

    public void testParseHasClassInOWLDL() throws Exception {
        ProfilesManager.setProfile(this.owlModel, OWLProfiles.OWL_DL.getURI());
        this.owlModel.createOWLNamedClass("Cls");
        this.owlModel.createOWLObjectProperty("slot");
        String expression = "slot $ Cls";
        try {
            this.parser.parseClass(this.owlModel, expression);
            ParseHasValueRestrictionsTestCase.assertFalse((String)"Expected failure!", (boolean)true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testParseIllegalHasFiller1() {
        this.owlModel.createOWLObjectProperty("slot");
        String expression = "slot $ 42";
        try {
            this.parser.parseClass(this.owlModel, expression);
            ParseHasValueRestrictionsTestCase.assertTrue((boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testParseIllegalHasFiller2() {
        this.owlModel.createOWLDatatypeProperty("slot");
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Cls");
        cls.createInstance("instance");
        String expression = "slot $ instance";
        try {
            this.parser.parseClass(this.owlModel, expression);
            ParseHasValueRestrictionsTestCase.assertTrue((boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

