/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.event.tests;

import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.event.ClassAdapter;
import edu.stanford.smi.protegex.owl.model.event.ClassListener;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;

public class ClassListenerTestCase
extends AbstractJenaTestCase {
    private int eventCount = 0;
    private ClassListener listener = new ClassAdapter(){

        public void addedToUnionDomainOf(RDFSClass cls, RDFProperty property) {
            ClassListenerTestCase classListenerTestCase = ClassListenerTestCase.this;
            classListenerTestCase.eventCount = classListenerTestCase.eventCount + 1;
        }

        public void instanceAdded(RDFSClass cls, RDFResource instance) {
            ClassListenerTestCase classListenerTestCase = ClassListenerTestCase.this;
            classListenerTestCase.eventCount = classListenerTestCase.eventCount + 1;
        }

        public void instanceRemoved(RDFSClass cls, RDFResource instance) {
            ClassListenerTestCase classListenerTestCase = ClassListenerTestCase.this;
            classListenerTestCase.eventCount = classListenerTestCase.eventCount + 1;
        }

        public void removedFromUnionDomainOf(RDFSClass cls, RDFProperty property) {
            ClassListenerTestCase classListenerTestCase = ClassListenerTestCase.this;
            classListenerTestCase.eventCount = classListenerTestCase.eventCount + 1;
        }

        public void subclassAdded(RDFSClass cls, RDFSClass subclass) {
            ClassListenerTestCase classListenerTestCase = ClassListenerTestCase.this;
            classListenerTestCase.eventCount = classListenerTestCase.eventCount + 1;
        }

        public void subclassRemoved(RDFSClass cls, RDFSClass subclass) {
            ClassListenerTestCase classListenerTestCase = ClassListenerTestCase.this;
            classListenerTestCase.eventCount = classListenerTestCase.eventCount + 1;
        }

        public void superclassAdded(RDFSClass cls, RDFSClass superclass) {
            ClassListenerTestCase classListenerTestCase = ClassListenerTestCase.this;
            classListenerTestCase.eventCount = classListenerTestCase.eventCount + 1;
        }

        public void superclassRemoved(RDFSClass cls, RDFSClass superclass) {
            ClassListenerTestCase classListenerTestCase = ClassListenerTestCase.this;
            classListenerTestCase.eventCount = classListenerTestCase.eventCount + 1;
        }
    };

    public void testEventCount() {
        RDFSNamedClass cls = this.owlModel.createRDFSNamedClass("Class");
        RDFSNamedClass subclass = this.owlModel.createRDFSNamedClass("Subclass");
        cls.addClassListener(this.listener);
        subclass.addClassListener(this.listener);
        ClassListenerTestCase.assertEquals((int)0, (int)this.eventCount);
        subclass.addSuperclass(cls);
        ClassListenerTestCase.assertEquals((int)2, (int)this.eventCount);
        subclass.removeSuperclass(cls);
        ClassListenerTestCase.assertEquals((int)4, (int)this.eventCount);
        RDFResource instance = cls.createInstance("instance");
        ClassListenerTestCase.assertEquals((int)5, (int)this.eventCount);
        instance.delete();
        ClassListenerTestCase.assertEquals((int)6, (int)this.eventCount);
        RDFProperty property = this.owlModel.createRDFProperty("property");
        property.setDomain(cls);
        ClassListenerTestCase.assertEquals((int)11, (int)this.eventCount);
        property.removeUnionDomainClass(cls);
        ClassListenerTestCase.assertEquals((int)14, (int)this.eventCount);
    }
}

