/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.factory.tests;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protegex.owl.model.OWLAllDifferent;
import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLDataRange;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLHasValue;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.RDFIndividual;
import edu.stanford.smi.protegex.owl.model.RDFList;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFUntypedResource;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLAllDifferent;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLHasValue;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLNamedClass;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLOntology;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFList;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFUntypedResource;
import edu.stanford.smi.protegex.owl.tests.AbstractOWLModelTestCase;
import java.util.Collection;
import java.util.Collections;

public class OWLJavaFactoryTestCase
extends AbstractOWLModelTestCase {
    private static final String TEST_CLASS_NAME = "TestCls";

    public void testCacheAfterChangedType() {
        String name = "slot";
        OWLObjectProperty objectSlot = this.owlModel.createOWLObjectProperty("slot");
        objectSlot.setProtegeType(this.owlModel.getOWLDatatypePropertyClass());
        OWLDatatypeProperty datatypeSlot = (OWLDatatypeProperty)this.owlModel.getRDFProperty("slot");
    }

    private void testCreate(String metaClsName, Class interFace, Class defaultClass) {
        OWLModel kb = this.owlModel;
        Cls metaCls = kb.getCls(metaClsName);
        kb.createCls(TEST_CLASS_NAME, Collections.singleton(this.owlModel.getOWLThingClass()), metaCls);
        Cls cls = kb.getCls(TEST_CLASS_NAME);
        OWLJavaFactoryTestCase.assertNotNull((Object)cls);
        OWLJavaFactoryTestCase.assertTrue((boolean)interFace.isInstance(cls));
        OWLJavaFactoryTestCase.assertTrue((boolean)defaultClass.isInstance(cls));
    }

    public void testCreateAllDifferentInstance() {
        OWLAllDifferent adi = this.owlModel.createOWLAllDifferent();
        OWLJavaFactoryTestCase.assertEquals(DefaultOWLAllDifferent.class, adi.getClass());
    }

    public void testCreateAllRestriction() {
        this.testCreate("owl:AllValuesFromRestriction", OWLAllValuesFrom.class, DefaultOWLAllValuesFrom.class);
    }

    public void testCreateHasValueRestriction() {
        this.testCreate("owl:HasValueRestriction", OWLHasValue.class, DefaultOWLHasValue.class);
    }

    public void testCreateOWLDataRange() {
        RDFSNamedClass dataRangeClass = this.owlModel.getOWLDataRangeClass();
        OWLJavaFactoryTestCase.assertTrue((boolean)(dataRangeClass.createInstance("test") instanceof OWLDataRange));
    }

    public void testCreateRDFDatatype() {
        OWLJavaFactoryTestCase.assertTrue((boolean)(this.owlModel.getRDFResource("xsd:int") instanceof RDFSDatatype));
    }

    public void testCreateRDFSCls() {
        this.testCreate("rdfs:Class", RDFSNamedClass.class, DefaultRDFSNamedClass.class);
    }

    public void testCreateRDFSlot() {
        OWLJavaFactoryTestCase.assertTrue((boolean)(this.owlModel.createRDFProperty("slot") instanceof RDFProperty));
    }

    public void testCreateRDFSNamedMetaclassInstance() {
        RDFSNamedClass metaclass = this.owlModel.createRDFSNamedSubclass("Metaclass", this.owlModel.getRDFSNamedClassClass());
        RDFResource frame = metaclass.createInstance("test");
        OWLJavaFactoryTestCase.assertEquals(DefaultRDFSNamedClass.class, frame.getClass());
    }

    public void testCreateOWLNamedClass() {
        this.testCreate("owl:Class", OWLNamedClass.class, DefaultOWLNamedClass.class);
    }

    public void testCreateListInstance() {
        RDFList list = this.owlModel.createRDFList(Collections.EMPTY_LIST.iterator());
        OWLJavaFactoryTestCase.assertEquals(DefaultRDFList.class, list.getClass());
    }

    public void testCreateOntologyInstance() {
        this.owlModel.getNamespaceManager().setPrefix("http://aldi.de#", "test");
        OWLOntology owlOntology = this.owlModel.createOWLOntology("test");
        OWLJavaFactoryTestCase.assertEquals(DefaultOWLOntology.class, owlOntology.getClass());
    }

    public void testRDFSClsMetaClsIsOWLCls() {
        Cls cls = this.owlModel.getCls("rdfs:Class");
        OWLJavaFactoryTestCase.assertTrue((boolean)(cls instanceof RDFSClass));
    }

    public void testRDFPropertyMetaclass() {
        OWLNamedClass c1 = (OWLNamedClass)this.owlModel.getRDFSNamedClass("rdf:Property");
        OWLNamedClass c2 = (OWLNamedClass)this.owlModel.getRDFResource("rdf:Property");
    }

    public void testCreateRDFUntypedResource() {
        RDFUntypedResource eri = this.owlModel.createRDFUntypedResource("http://aldi.de");
        OWLJavaFactoryTestCase.assertEquals(DefaultRDFUntypedResource.class, eri.getClass());
    }

    public void testCreateSomeRestriction() {
        this.testCreate("owl:SomeValuesFromRestriction", OWLSomeValuesFrom.class, DefaultOWLSomeValuesFrom.class);
    }

    public void testThingIsNamedCls() {
        OWLJavaFactoryTestCase.assertTrue((boolean)(this.owlModel.getOWLThingClass() instanceof OWLNamedClass));
    }

    public void testRDFIndividual() {
        RDFSNamedClass cls = this.owlModel.createRDFSNamedClass("Class");
        RDFIndividual individual = cls.createRDFIndividual("Test");
        OWLJavaFactoryTestCase.assertFalse((boolean)(individual instanceof OWLIndividual));
    }

    public void testOWLIndividual() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Class");
        OWLIndividual individual = cls.createOWLIndividual("Test");
        OWLJavaFactoryTestCase.assertTrue((boolean)(individual instanceof OWLIndividual));
    }

    public void testOWLDeprecatedClass() {
        RDFSNamedClass c = this.owlModel.getOWLDeprecatedClassClass();
        RDFResource resource = c.createInstance("MyClass");
        OWLJavaFactoryTestCase.assertTrue((boolean)(resource instanceof RDFSNamedClass));
    }

    public void testMixedClass() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Person");
        RDFResource instance = cls.createInstance("Instance");
        OWLJavaFactoryTestCase.assertTrue((boolean)(instance instanceof OWLIndividual));
        instance.addProtegeType(this.owlModel.getOWLNamedClassClass());
        Collection types = instance.getProtegeTypes();
        OWLJavaFactoryTestCase.assertEquals((int)2, (int)types.size());
        OWLJavaFactoryTestCase.assertTrue((boolean)types.contains(cls));
        OWLJavaFactoryTestCase.assertTrue((boolean)types.contains(this.owlModel.getOWLNamedClassClass()));
        instance = this.owlModel.getRDFResource(instance.getName());
        OWLJavaFactoryTestCase.assertTrue((boolean)(instance instanceof OWLNamedClass));
    }
}

