/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.framestore;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protegex.owl.model.OWLCardinality;
import edu.stanford.smi.protegex.owl.model.OWLCardinalityBase;
import edu.stanford.smi.protegex.owl.model.OWLMaxCardinality;
import edu.stanford.smi.protegex.owl.model.OWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLRestriction;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.framestore.AbstractRestrictionUpdater;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import java.util.Collections;
import java.util.List;

class CardinalityRestrictionUpdater
extends AbstractRestrictionUpdater {
    private Facet maxCardinalityFacet;
    private Facet minCardinalityFacet;

    CardinalityRestrictionUpdater(AbstractOWLModel owlModel) {
        super(owlModel);
        this.maxCardinalityFacet = owlModel.getFacet(":MAXIMUM-CARDINALITY");
        this.minCardinalityFacet = owlModel.getFacet(":MINIMUM-CARDINALITY");
    }

    private OWLCardinalityBase createCardinalityRestriction(RDFProperty property, Facet facet, int cardinality) {
        if (facet.equals(this.minCardinalityFacet)) {
            return this.owlModel.createOWLMinCardinality(property, cardinality);
        }
        return this.owlModel.createOWLMaxCardinality(property, cardinality);
    }

    private void ensureCardinalityRestriction(Cls cls, RDFProperty property, Facet facet) {
        int cardinality;
        if (cls.hasDirectlyOverriddenTemplateFacet((Slot)property, facet) && !this.hasCardinalityRestriction(cls, (Slot)property, facet, cardinality = ((Integer)cls.getTemplateFacetValue((Slot)property, facet)).intValue())) {
            this.removeRestrictions(cls, property, this.getCardinalityRestrictionCls(facet));
            OWLCardinalityBase restriction = this.createCardinalityRestriction(property, facet, cardinality);
            cls.addDirectSuperclass((Cls)restriction);
            this.log("+ " + restriction.getClass().getName() + " " + restriction.getBrowserText() + " to " + cls.getName() + "." + property.getName());
        }
    }

    private Cls getCardinalityRestrictionCls(Facet facet) {
        if (facet.equals(this.minCardinalityFacet)) {
            return this.owlModel.getCls("owl:MinCardinalityRestriction");
        }
        return this.owlModel.getCls("owl:MaxCardinalityRestriction");
    }

    private boolean hasCardinalityRestriction(Cls cls, Slot slot, Facet facet, int cardinality) {
        Cls metaCls = this.getCardinalityRestrictionCls(facet);
        return this.hasCardinalityRestriction(cls, slot, metaCls, cardinality);
    }

    private boolean hasCardinalityRestriction(Cls cls, Slot slot, Cls metaCls, int cardinality) {
        for (Cls superCls : cls.getDirectSuperclasses()) {
            OWLCardinalityBase cardinalityRestriction;
            if (!superCls.getDirectType().equals(metaCls) || !slot.equals((cardinalityRestriction = (OWLCardinalityBase)superCls).getOnProperty()) || cardinalityRestriction.getCardinality() != cardinality) continue;
            return true;
        }
        return false;
    }

    private void updateBothCardinalityFacets(RDFSNamedClass cls, Slot slot) {
        cls.setTemplateFacetValues(slot, this.minCardinalityFacet, Collections.EMPTY_LIST);
        cls.setTemplateFacetValues(slot, this.maxCardinalityFacet, Collections.EMPTY_LIST);
        OWLCardinality restriction = (OWLCardinality)this.getDirectRestriction(cls, slot, OWLCardinality.class);
        if (restriction != null) {
            int cardinality = restriction.getCardinality();
            cls.addTemplateFacetValue(slot, this.minCardinalityFacet, new Integer(cardinality));
            cls.addTemplateFacetValue(slot, this.maxCardinalityFacet, new Integer(cardinality));
            this.log("+ :Max and :MinimumCardinality overrides to " + cls.getName() + "." + slot.getName() + ": " + cardinality);
        }
    }

    private void updateCardinalityRestrictions(Cls cls, RDFProperty slot, Facet changedFacet, Facet otherFacet) {
        if (cls.hasDirectlyOverriddenTemplateFacet((Slot)slot, changedFacet)) {
            this.ensureCardinalityRestriction(cls, slot, changedFacet);
            Integer cardinality = (Integer)cls.getTemplateFacetValue((Slot)slot, changedFacet);
            if (cls.hasDirectlyOverriddenTemplateFacet((Slot)slot, otherFacet) && cardinality.equals(cls.getTemplateFacetValue((Slot)slot, otherFacet))) {
                this.removeRestrictions(cls, slot, this.owlModel.getCls("owl:MinCardinalityRestriction"));
                this.removeRestrictions(cls, slot, this.owlModel.getCls("owl:MaxCardinalityRestriction"));
                if (!this.hasCardinalityRestriction(cls, (Slot)slot, this.owlModel.getCls("owl:CardinalityRestriction"), (int)cardinality)) {
                    this.removeRestrictions(cls, slot, this.owlModel.getCls("owl:CardinalityRestriction"));
                    OWLCardinality restriction = this.owlModel.createOWLCardinality(slot, cardinality);
                    cls.addDirectSuperclass((Cls)restriction);
                    this.log("+ OWLCardinality " + restriction.getBrowserText() + " to " + cls.getName() + "." + slot.getName());
                }
            } else {
                this.removeRestrictions(cls, slot, this.owlModel.getCls("owl:CardinalityRestriction"));
                this.ensureCardinalityRestriction(cls, slot, changedFacet);
                this.ensureCardinalityRestriction(cls, slot, otherFacet);
            }
        } else {
            this.removeRestrictions(cls, slot, this.getCardinalityRestrictionCls(changedFacet));
            this.removeRestrictions(cls, slot, this.owlModel.getCls("owl:CardinalityRestriction"));
            this.ensureCardinalityRestriction(cls, slot, otherFacet);
        }
    }

    protected void updateMaximumCardinalityFacet(RDFSNamedClass cls, Slot slot) {
        OWLMaxCardinality restriction = (OWLMaxCardinality)this.getDirectRestriction(cls, slot, OWLMaxCardinality.class);
        RDFSNamedClass c = cls;
        List oldValues = c.getDirectTemplateFacetValues(slot, this.maxCardinalityFacet);
        if (restriction != null) {
            int cardinality = restriction.getCardinality();
            Integer value = new Integer(cardinality);
            if (!oldValues.contains(value)) {
                c.setTemplateFacetValue(slot, this.maxCardinalityFacet, value);
            }
        } else if (!oldValues.isEmpty()) {
            c.setTemplateFacetValues(slot, this.maxCardinalityFacet, Collections.EMPTY_LIST);
        }
    }

    protected void updateMinimumCardinalityFacet(RDFSNamedClass cls, Slot slot) {
        RDFSNamedClass c = cls;
        List oldValues = c.getDirectTemplateFacetValues(slot, this.minCardinalityFacet);
        OWLMinCardinality restriction = (OWLMinCardinality)this.getDirectRestriction(cls, slot, OWLMinCardinality.class);
        if (restriction != null) {
            int cardinality = restriction.getCardinality();
            Integer value = new Integer(cardinality);
            if (!oldValues.contains(value)) {
                c.setTemplateFacetValue(slot, this.minCardinalityFacet, value);
            }
        } else if (!oldValues.isEmpty()) {
            c.setTemplateFacetValues(slot, this.minCardinalityFacet, Collections.EMPTY_LIST);
        }
    }

    public void copyFacetValuesIntoNamedClass(RDFSNamedClass cls, OWLRestriction restriction) {
        RDFProperty slot = restriction.getOnProperty();
        if (slot != null) {
            if (restriction instanceof OWLCardinality) {
                this.updateBothCardinalityFacets(cls, slot);
            } else if (restriction instanceof OWLMaxCardinality) {
                this.updateMaximumCardinalityFacet(cls, slot);
            } else if (restriction instanceof OWLMinCardinality) {
                this.updateMinimumCardinalityFacet(cls, slot);
            }
        }
    }

    public void updateRestrictions(OWLNamedClass cls, RDFProperty property, Facet facet) {
        if (facet.equals(this.maxCardinalityFacet)) {
            this.updateCardinalityRestrictions(cls, property, this.maxCardinalityFacet, this.minCardinalityFacet);
        } else if (facet.equals(this.minCardinalityFacet)) {
            this.updateCardinalityRestrictions(cls, property, this.minCardinalityFacet, this.maxCardinalityFacet);
        }
    }
}

