/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.framestore.tests;

import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLHasValue;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLNamedClass;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;

public class HasValueRestrictionUpdaterTestCase
extends AbstractJenaTestCase {
    public void testAddHasRestrictionOnStringProperty() {
        OWLNamedClass cls = this.owlModel.createOWLNamedSubclass("Cls", this.owlModel.getOWLThingClass());
        OWLDatatypeProperty slot = this.owlModel.createOWLDatatypeProperty("slot", this.owlModel.getXSDstring());
        slot.addUnionDomainClass(cls);
        OWLHasValue hasRestriction = this.owlModel.createOWLHasValue(slot, "value");
        cls.addSuperclass(hasRestriction);
    }

    public void testValuesFacetOverload1() {
        DefaultOWLNamedClass cls = (DefaultOWLNamedClass)this.owlModel.createOWLNamedClass("Cls");
        OWLDatatypeProperty slot = this.owlModel.createOWLDatatypeProperty("slot", this.owlModel.getXSDboolean());
        slot.addUnionDomainClass(cls);
        Facet facet = this.owlModel.getFacet(":VALUES");
        cls.setTemplateFacetValue(slot, facet, Boolean.TRUE);
        HasValueRestrictionUpdaterTestCase.assertTrue((boolean)cls.hasDirectlyOverriddenTemplateSlot(slot));
        HasValueRestrictionUpdaterTestCase.assertTrue((boolean)cls.hasDirectlyOverriddenTemplateFacet(slot, facet));
        HasValueRestrictionUpdaterTestCase.assertEquals((Object)Boolean.TRUE, (Object)cls.getDirectTemplateFacetValue(slot, facet));
        HasValueRestrictionUpdaterTestCase.assertSize(2, cls.getDirectSuperclasses());
    }

    public void testValuesFacetOverload2() {
        DefaultOWLNamedClass cls = (DefaultOWLNamedClass)this.owlModel.createOWLNamedClass("Cls");
        OWLDatatypeProperty slot = this.owlModel.createOWLDatatypeProperty("slot", this.owlModel.getXSDboolean());
        slot.addUnionDomainClass(cls);
        Facet facet = this.owlModel.getFacet(":VALUES");
        cls.setTemplateSlotValue(slot, Boolean.TRUE);
        HasValueRestrictionUpdaterTestCase.assertTrue((boolean)cls.hasDirectlyOverriddenTemplateSlot(slot));
        HasValueRestrictionUpdaterTestCase.assertTrue((boolean)cls.hasDirectlyOverriddenTemplateFacet(slot, facet));
        HasValueRestrictionUpdaterTestCase.assertEquals((Object)Boolean.TRUE, (Object)cls.getDirectTemplateFacetValue(slot, facet));
        HasValueRestrictionUpdaterTestCase.assertSize(2, cls.getDirectSuperclasses());
    }
}

