/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl;

import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protegex.owl.model.OWLAllDifferent;
import edu.stanford.smi.protegex.owl.model.RDFList;
import edu.stanford.smi.protegex.owl.model.RDFObject;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLIndividual;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFList;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.model.visitor.OWLModelVisitor;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DefaultOWLAllDifferent
extends DefaultOWLIndividual
implements OWLAllDifferent {
    public DefaultOWLAllDifferent(KnowledgeBase kb, FrameID id) {
        super(kb, id);
    }

    public DefaultOWLAllDifferent() {
    }

    public void accept(OWLModelVisitor visitor) {
        visitor.visitOWLAllDifferent(this);
    }

    public void addDistinctMember(RDFResource resource) {
        RDFProperty property = this.getOWLModel().getRDFProperty("owl:distinctMembers");
        RDFList value = (RDFList)this.getPropertyValue(property);
        if (value == null) {
            RDFList list = this.getOWLModel().createRDFList();
            list.setFirst(resource);
            list.setRest(this.getOWLModel().getRDFNil());
            this.setPropertyValue(property, list);
        } else {
            value.append(resource);
        }
    }

    public boolean equalsStructurally(RDFObject object) {
        if (object instanceof OWLAllDifferent) {
            OWLAllDifferent comp = (OWLAllDifferent)object;
            return OWLUtil.equalsStructurally(this.getDistinctMembers(), comp.getDistinctMembers());
        }
        return false;
    }

    public String getBrowserText() {
        String str = "AllDifferent {";
        Iterator it = this.listDistinctMembers();
        while (it.hasNext() && str.length() < 80) {
            RDFResource instance = (RDFResource)it.next();
            str = String.valueOf(str) + instance.getBrowserText();
            if (!it.hasNext()) continue;
            str = String.valueOf(str) + ", ";
        }
        if (it.hasNext()) {
            str = String.valueOf(str) + "...";
        }
        str = String.valueOf(str) + "}";
        return str;
    }

    public Collection getDistinctMembers() {
        RDFProperty property = this.getOWLModel().getRDFProperty("owl:distinctMembers");
        RDFList list = (RDFList)this.getPropertyValue(property);
        if (list == null) {
            return Collections.EMPTY_LIST;
        }
        return list.getValues();
    }

    public Iterator listDistinctMembers() {
        return this.getDistinctMembers().iterator();
    }

    public Set getReferringAnonymousClasses() {
        return Collections.EMPTY_SET;
    }

    public void removeDistinctMember(RDFResource instance) {
        RDFProperty property = this.getOWLModel().getRDFProperty("owl:distinctMembers");
        DefaultRDFList.removeListValue(this, property, instance);
    }

    public void setDistinctMembers(List values) {
        for (RDFResource resource : this.getDistinctMembers()) {
            this.removeDistinctMember(resource);
        }
        for (RDFResource resource : values) {
            this.addDistinctMember(resource);
        }
    }
}

