/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.util;

import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.jena.parser.ProtegeOWLParser;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.menu.OWLMenuProjectPlugin;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;

public class ImportHelper {
    private JenaOWLModel owlModel;
    private Set ontologyURIs;

    public ImportHelper(JenaOWLModel owlModel) {
        this.owlModel = owlModel;
        this.ontologyURIs = new HashSet();
    }

    public void addImport(URI ontologyURI) {
        this.ontologyURIs.add(ontologyURI);
    }

    public void importOntologies() throws Exception {
        this.importOntologies(true);
    }

    public void importOntologies(boolean reloadGUI) throws Exception {
        HashSet<URI> importedOntologies = new HashSet<URI>();
        for (URI ontologyURI : this.ontologyURIs) {
            if (this.owlModel.getAllImports().contains(ontologyURI.toString())) continue;
            ProtegeOWLParser.addImport(this.owlModel, ontologyURI);
            for (OWLOntology owlOntology : this.owlModel.getOWLOntologies()) {
                TripleStore ts = this.owlModel.getTripleStoreModel().getActiveTripleStore();
                if (this.owlModel.getTripleStoreModel().getHomeTripleStore(owlOntology) != ts) continue;
                owlOntology.addImports(ontologyURI);
                break;
            }
            importedOntologies.add(ontologyURI);
        }
        if (importedOntologies.size() > 0 && ProtegeOWLParser.inUI) {
            this.owlModel.getTripleStoreModel().updateEditableResourceState();
            OWLMenuProjectPlugin.makeHiddenClsesWithSubclassesVisible(this.owlModel);
            if (reloadGUI) {
                ProtegeUI.reloadUI(this.owlModel);
            }
        }
    }
}

