/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.util;

import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLCardinality;
import edu.stanford.smi.protegex.owl.model.OWLComplementClass;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLEnumeratedClass;
import edu.stanford.smi.protegex.owl.model.OWLHasValue;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLMaxCardinality;
import edu.stanford.smi.protegex.owl.model.OWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.visitor.OWLModelVisitorAdapter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ModelMetrics
extends OWLModelVisitorAdapter {
    private OWLModel model;
    private int owlClassCount;
    private int namedClassCount = 0;
    private int primitiveClassCount = 0;
    private int definedClassCount = 0;
    private int objectPropertyCount = 0;
    private int datatypePropertyCount = 0;
    private int annotationPropertyCount = 0;
    private int owlIndividualCount = 0;
    private int restrictionCount;
    private int allValuesFromCount;
    private int someValuesFromCount;
    private int hasValueCount;
    private int cardinalityCount;
    private int maxCardinalityCount;
    private int minCardinalityCount;
    private int unionClassCount;
    private int propertDomainCount;
    private int propertyRangeCount;
    private int complementClassCount;
    private int enumeratedClassCount;
    private HashMap propertyUsageCountMap;
    private HashMap classInstantiationCountMap;
    private HashMap siblingClassCount;
    private HashMap parentClassCount;
    private HashMap inferredParentClassCount;
    private int inversePropertyCount = 0;
    private boolean stop;

    public ModelMetrics(OWLModel model) {
        this.model = model;
        this.propertyUsageCountMap = new HashMap();
        this.classInstantiationCountMap = new HashMap();
        this.siblingClassCount = new HashMap();
        this.parentClassCount = new HashMap();
        this.inferredParentClassCount = new HashMap();
        this.stop = false;
    }

    public void calculateMetrics() {
        this.stop = false;
        for (RDFResource curResource : this.model.getRDFResources()) {
            if (!curResource.isSystem()) {
                curResource.accept(this);
            }
            if (this.stop) break;
        }
    }

    public int getNamedClassCount() {
        return this.namedClassCount;
    }

    public int getOwlClassCount() {
        return this.owlClassCount;
    }

    public int getPrimitiveClassCount() {
        return this.primitiveClassCount;
    }

    public int getDefinedClassCount() {
        return this.definedClassCount;
    }

    public int getObjectPropertyCount() {
        return this.objectPropertyCount;
    }

    public int getDatatypePropertyCount() {
        return this.datatypePropertyCount;
    }

    public int getAnnotationPropertyCount() {
        return this.annotationPropertyCount;
    }

    public int getPropertyCount() {
        return this.objectPropertyCount + this.datatypePropertyCount + this.annotationPropertyCount;
    }

    public int getOwlIndividualCount() {
        return this.owlIndividualCount;
    }

    public int getRestrictionCount() {
        return this.restrictionCount;
    }

    public int getAllValuesFromCount() {
        return this.allValuesFromCount;
    }

    public int getSomeValuesFromCount() {
        return this.someValuesFromCount;
    }

    public int getHasValueCount() {
        return this.hasValueCount;
    }

    public int getCardinalityCount() {
        return this.cardinalityCount;
    }

    public int getMaxCardinalityCount() {
        return this.maxCardinalityCount;
    }

    public int getMinCardinalityCount() {
        return this.minCardinalityCount;
    }

    public int getUnionClassCount() {
        return this.unionClassCount;
    }

    public int getPropertDomainCount() {
        return this.propertDomainCount;
    }

    public int getPropertyRangeCount() {
        return this.propertyRangeCount;
    }

    public int getComplementClassCount() {
        return this.complementClassCount;
    }

    public int getEnumeratedClassCount() {
        return this.enumeratedClassCount;
    }

    private int getMean(HashMap map) {
        int sum = 0;
        for (Integer curInt : map.keySet()) {
            sum += curInt.intValue();
        }
        return (int)Math.round((double)sum / (double)map.size());
    }

    private int getMax(HashMap map) {
        int count = 0;
        for (Integer i : map.keySet()) {
            if (i <= count) continue;
            count = i;
        }
        return count;
    }

    private int getMode(HashMap map) {
        int max = 0;
        int mode = 0;
        for (Integer sibCount : map.keySet()) {
            int curCount = (Integer)map.get(sibCount);
            if (curCount <= max) continue;
            max = curCount;
            mode = sibCount;
        }
        return mode;
    }

    public int getMaxSiblings() {
        return this.getMax(this.siblingClassCount);
    }

    public int getMeanSiblings() {
        return this.getMean(this.siblingClassCount);
    }

    public int getModeSiblings() {
        return this.getMode(this.siblingClassCount);
    }

    public int getMaxParents() {
        return this.getMax(this.parentClassCount);
    }

    public int getMaxInferredParents() {
        return this.getMax(this.inferredParentClassCount);
    }

    public int getMeanParents() {
        return this.getMean(this.parentClassCount);
    }

    public int getModeParents() {
        return this.getMode(this.parentClassCount);
    }

    public int getMeanInferredParents() {
        return this.getMean(this.inferredParentClassCount);
    }

    public int getModeInferredParents() {
        return this.getMode(this.inferredParentClassCount);
    }

    public int getInversePropertyCount() {
        return this.inversePropertyCount;
    }

    private void incrementPropertyUsage(RDFProperty property) {
        this.incrementCount(property, this.propertyUsageCountMap);
    }

    private void incrementClassInstantiation(RDFSClass cls) {
        this.incrementCount(cls, this.classInstantiationCountMap);
    }

    private void logSiblingClassCount(int count) {
        this.logCount(count, this.siblingClassCount);
    }

    private void logParentClassCount(int count) {
        this.logCount(count, this.parentClassCount);
    }

    private void logInferredParentClassCount(int count) {
        this.logCount(count, this.inferredParentClassCount);
    }

    private void logCount(int count, HashMap map) {
        Integer countInteger = new Integer(count);
        Integer countOfCount = (Integer)map.get(countInteger);
        if (countOfCount == null) {
            countOfCount = new Integer(0);
        }
        countOfCount = new Integer(countOfCount + 1);
        map.put(countInteger, countOfCount);
    }

    private void incrementCount(RDFResource resource, Map map) {
        Integer count = (Integer)map.get(resource);
        if (count == null) {
            count = new Integer(0);
            map.put(resource, count);
        }
        map.put(resource, new Integer(count + 1));
    }

    public void visitOWLAllValuesFrom(OWLAllValuesFrom owlAllValuesFrom) {
        ++this.allValuesFromCount;
        ++this.restrictionCount;
        ++this.owlClassCount;
    }

    public void visitOWLCardinality(OWLCardinality owlCardinality) {
        ++this.cardinalityCount;
        ++this.restrictionCount;
        ++this.owlClassCount;
    }

    public void visitOWLComplementClass(OWLComplementClass owlComplementClass) {
        ++this.complementClassCount;
        ++this.restrictionCount;
        ++this.owlClassCount;
    }

    public void visitOWLDatatypeProperty(OWLDatatypeProperty owlDatatypeProperty) {
        if (owlDatatypeProperty.isAnnotationProperty()) {
            ++this.annotationPropertyCount;
        } else {
            ++this.datatypePropertyCount;
            RDFSClass domain = owlDatatypeProperty.getDomain(false);
            if (domain != null && !domain.equals(this.model.getOWLThingClass())) {
                ++this.propertDomainCount;
            }
            this.incrementPropertyUsage(owlDatatypeProperty);
        }
    }

    public void visitOWLEnumeratedClass(OWLEnumeratedClass owlEnumeratedClass) {
        ++this.enumeratedClassCount;
        ++this.owlClassCount;
    }

    public void visitOWLHasValue(OWLHasValue owlHasValue) {
        ++this.hasValueCount;
        ++this.restrictionCount;
        ++this.owlClassCount;
    }

    public void visitOWLIndividual(OWLIndividual owlIndividual) {
        ++this.owlIndividualCount;
        Iterator it = owlIndividual.getRDFTypes().iterator();
        while (it.hasNext()) {
            this.incrementClassInstantiation((RDFSClass)it.next());
        }
    }

    public void visitOWLIntersectionClass(OWLIntersectionClass owlIntersectionClass) {
        ++this.owlClassCount;
    }

    public void visitOWLMaxCardinality(OWLMaxCardinality owlMaxCardinality) {
        ++this.maxCardinalityCount;
        ++this.restrictionCount;
        ++this.owlClassCount;
    }

    public void visitOWLMinCardinality(OWLMinCardinality owlMinCardinality) {
        ++this.minCardinalityCount;
        ++this.restrictionCount;
        ++this.owlClassCount;
    }

    public void visitOWLNamedClass(OWLNamedClass owlNamedClass) {
        ++this.namedClassCount;
        ++this.owlClassCount;
        Collection namedSupers = owlNamedClass.getNamedSuperclasses();
        if (namedSupers.size() > 2) {
            namedSupers.remove(this.model.getOWLThingClass());
        }
        this.logParentClassCount(namedSupers.size());
        this.logInferredParentClassCount(owlNamedClass.getInferredSuperclasses().size());
        int namedSubs = owlNamedClass.getNamedSubclasses().size();
        if (namedSubs > 0) {
            this.logSiblingClassCount(namedSubs);
        }
        if (owlNamedClass.getEquivalentClasses().size() > 0) {
            ++this.definedClassCount;
        } else {
            ++this.primitiveClassCount;
        }
    }

    public void visitOWLObjectProperty(OWLObjectProperty owlObjectProperty) {
        if (owlObjectProperty.isAnnotationProperty()) {
            ++this.annotationPropertyCount;
        } else {
            RDFResource resource;
            ++this.objectPropertyCount;
            RDFSClass domain = owlObjectProperty.getDomain(false);
            if (domain != null && !domain.equals(this.model.getOWLThingClass())) {
                ++this.propertDomainCount;
            }
            if ((resource = owlObjectProperty.getRange(false)) != null && !resource.equals(this.model.getOWLThingClass())) {
                ++this.propertyRangeCount;
            }
            this.incrementPropertyUsage(owlObjectProperty);
            if (owlObjectProperty.getInverseProperty() != null) {
                ++this.inversePropertyCount;
            }
        }
    }

    public void visitOWLSomeValuesFrom(OWLSomeValuesFrom owlSomeValuesFrom) {
        ++this.someValuesFromCount;
        ++this.restrictionCount;
        ++this.owlClassCount;
    }

    public void visitOWLUnionClass(OWLUnionClass owlUnionClass) {
        ++this.unionClassCount;
        ++this.owlClassCount;
    }

    public void stopCalculating() {
        this.stop = true;
    }
}

