/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.repository.impl;

import edu.stanford.smi.protegex.owl.repository.impl.LocalFolderRepository;
import edu.stanford.smi.protegex.owl.repository.util.RepositoryUtil;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class RelativeFolderRepository
extends LocalFolderRepository {
    private String relativeURL;

    public RelativeFolderRepository(URL baseURL, String relativeURL) throws MalformedURLException, URISyntaxException {
        this(baseURL, relativeURL, RepositoryUtil.isForcedToBeReadOnly(RelativeFolderRepository.getURI(baseURL, relativeURL).getQuery()));
    }

    public RelativeFolderRepository(URL baseURL, String relativeURL, boolean forceReadOnly) throws MalformedURLException, URISyntaxException {
        super(new File(RelativeFolderRepository.getURI(baseURL, relativeURL).getPath()), forceReadOnly);
        this.relativeURL = RelativeFolderRepository.stripQuery(relativeURL);
    }

    private static URI getURI(URL baseURL, String relativeURL) throws MalformedURLException, URISyntaxException {
        return new URI(new URL(baseURL, relativeURL).toString());
    }

    private static String stripQuery(String relativeURL) {
        int index = relativeURL.indexOf(63);
        if (index != -1) {
            return relativeURL.substring(0, index);
        }
        return relativeURL;
    }

    public String getRepositoryDescriptor() {
        try {
            URI uri = new URI(this.relativeURL);
            return String.valueOf(uri.toString()) + "?" + "forceReadOnly" + "=" + this.isForceReadOnly();
        }
        catch (URISyntaxException e) {
            return "";
        }
    }

    public String getRepositoryDescription() {
        return "Relative URL: " + this.relativeURL + "  (" + this.getFile().toString() + ")";
    }
}

