/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.bridge;

import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.swrl.bridge.Argument;
import edu.stanford.smi.protegex.owl.swrl.bridge.Info;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.InvalidIndividualNameException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.SWRLRuleEngineBridgeException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

public class IndividualInfo
extends Info
implements Argument {
    private Collection classNames;

    public IndividualInfo(OWLIndividual individual) throws SWRLRuleEngineBridgeException {
        super(individual.getName());
        this.classNames = this.getDefiningClassNames(individual);
    }

    public IndividualInfo(OWLModel owlModel, String individualName) throws SWRLRuleEngineBridgeException {
        super(individualName);
        OWLIndividual individual = owlModel.getOWLIndividual(individualName);
        if (individual == null) {
            throw new InvalidIndividualNameException(individualName);
        }
        this.classNames = this.getDefiningClassNames(individual);
    }

    public IndividualInfo(String individualName, String className) throws SWRLRuleEngineBridgeException {
        super(individualName);
        this.classNames = new ArrayList();
        this.classNames.add(className);
    }

    public IndividualInfo(String individualName) {
        super(individualName);
        this.classNames = new ArrayList();
    }

    public Collection getClassNames() {
        return this.classNames;
    }

    public void write2OWL(OWLModel owlModel) throws SWRLRuleEngineBridgeException {
        OWLIndividual individual = owlModel.getOWLIndividual(this.getName());
        if (individual == null) {
            throw new InvalidIndividualNameException(this.getName());
        }
        for (String className : this.getClassNames()) {
            OWLNamedClass rdfsClass = owlModel.getOWLNamedClass(className);
            if (individual.hasRDFType(rdfsClass)) continue;
            individual.addRDFType(rdfsClass);
        }
    }

    public String toString() {
        return "Individual(name: " + this.getName() + ", classNames: " + this.classNames + ")";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        IndividualInfo info = (IndividualInfo)obj;
        return (this.getName() == info.getName() || this.getName() != null && this.getName().equals(info.getName())) && (this.classNames == info.classNames || this.classNames != null && this.classNames.equals(info.classNames));
    }

    public int hashCode() {
        int hash = 7;
        hash += this.getName() == null ? 0 : this.getName().hashCode();
        return hash += this.classNames == null ? 0 : this.classNames.hashCode();
    }

    private Collection getDefiningClassNames(OWLIndividual individual) throws SWRLRuleEngineBridgeException {
        HashSet<String> definingClassNames = new HashSet<String>();
        for (RDFSClass assertedClass : individual.getRDFTypes()) {
            definingClassNames.add(assertedClass.getName());
            for (RDFSClass superClass : assertedClass.getNamedSuperclasses(true)) {
                definingClassNames.add(superClass.getName());
            }
        }
        return definingClassNames;
    }
}

