/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.ui.code;

import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.ui.InstanceDisplay;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLImp;
import edu.stanford.smi.protegex.owl.swrl.parser.SWRLParser;
import edu.stanford.smi.protegex.owl.swrl.ui.code.SWRLSymbolPanel;
import edu.stanford.smi.protegex.owl.swrl.ui.code.SWRLTextArea;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.dialogs.ModalDialogFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.logging.Level;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class SWRLTextAreaPanel
extends JPanel
implements ModalDialogFactory.CloseCallback {
    private OWLModel owlModel;
    private SWRLSymbolPanel symbolPanel;
    private SWRLTextArea textArea;

    public SWRLTextAreaPanel(OWLModel owlModel) {
        this(owlModel, null);
    }

    public SWRLTextAreaPanel(OWLModel anOWLModel, SWRLImp imp) {
        this.owlModel = anOWLModel;
        this.symbolPanel = new SWRLSymbolPanel(anOWLModel, false, false);
        this.textArea = new SWRLTextArea(anOWLModel, this.symbolPanel){

            protected void checkExpression(String text) throws Throwable {
                SWRLTextAreaPanel.this.owlModel.getOWLClassDisplay().getParser().checkClass(SWRLTextAreaPanel.this.owlModel, text);
            }
        };
        if (imp != null && imp.getHead() != null) {
            String text = imp.getBrowserText();
            this.textArea.setText(text);
            this.textArea.reformatText();
        }
        this.symbolPanel.setSymbolEditor(this.textArea);
        InstanceDisplay id = new InstanceDisplay(anOWLModel.getProject(), false, false);
        id.setInstance((Instance)imp);
        this.setLayout(new BorderLayout(0, 8));
        this.add("North", (Component)id);
        JScrollPane sp = new JScrollPane(this.textArea);
        sp.setPreferredSize(new Dimension(100, 250));
        this.add("Center", sp);
        this.add("South", this.symbolPanel);
    }

    public boolean canClose(int result) {
        if (result == 1) {
            String uniCodeText = this.textArea.getText();
            if (uniCodeText.length() == 0) {
                return false;
            }
            try {
                SWRLParser parser = new SWRLParser(this.owlModel);
                parser.parse(uniCodeText);
                return true;
            }
            catch (Exception ex) {
                this.symbolPanel.displayError(ex);
                return false;
            }
        }
        return true;
    }

    public SWRLImp getResultAsImp() {
        try {
            String uniCodeText = this.textArea.getText();
            SWRLParser parser = new SWRLParser(this.owlModel);
            parser.setParseOnly(false);
            return parser.parse(uniCodeText);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public String getResultAsString() {
        return this.textArea.getText();
    }

    public static boolean showEditDialog(Component parent, OWLModel owlModel, SWRLImp imp) {
        SWRLTextAreaPanel panel = new SWRLTextAreaPanel(owlModel, imp);
        String title = "Edit SWRL Rule";
        if (ProtegeUI.getModalDialogFactory().showDialog(parent, panel, title, 11, panel) == 1) {
            try {
                imp.setExpression(panel.getResultAsString());
                return true;
            }
            catch (Exception ex) {
                System.err.println("[SWRLTextAreaPanel]  Fatal error");
                Log.getLogger().log(Level.SEVERE, "Exception caught", ex);
            }
        }
        return false;
    }
}

