/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.ui.table;

import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.event.ClassAdapter;
import edu.stanford.smi.protegex.owl.model.event.ClassListener;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLFactory;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLImp;
import edu.stanford.smi.protegex.owl.swrl.parser.SWRLParser;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.owltable.SymbolTableModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;

public class SWRLTableModel
extends AbstractTableModel
implements Disposable,
SymbolTableModel {
    public static final int COL_NAME = 0;
    public static final int COL_EXPRESSION = 1;
    public static final int COL_COUNT = 2;
    private ClassListener clsListener = new ClassAdapter(){

        public void instanceAdded(RDFSClass cls, RDFResource instance) {
            final SWRLImp newImp = (SWRLImp)instance;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SWRLTableModel.this.perhapsAdd(newImp);
                }
            });
        }

        public void instanceRemoved(RDFSClass cls, RDFResource instance) {
            SWRLTableModel.this.perhapsRemove((SWRLImp)instance);
        }
    };
    private List imps = new ArrayList();
    private RDFResource rdfResource;
    private OWLModel owlModel;

    public SWRLTableModel(OWLModel owlModel) {
        this.owlModel = owlModel;
        SWRLFactory factory = new SWRLFactory(owlModel);
        this.imps.addAll(factory.getImps());
        this.sortImps();
        this.initClsListener();
    }

    public SWRLTableModel(RDFResource resource) {
        this.rdfResource = resource;
        this.owlModel = resource.getOWLModel();
        this.addReferencingImps(resource);
        this.sortImps();
        this.initClsListener();
    }

    private void addReferencingImps(RDFResource rdfResource) {
        OWLModel owlModel = rdfResource.getOWLModel();
        SWRLFactory factory = new SWRLFactory(owlModel);
        Collection allImps = factory.getImps();
        for (SWRLImp imp : allImps) {
            if (!this.isSuitable(imp)) continue;
            this.imps.add(imp);
        }
    }

    public void dispose() {
        this.owlModel.getRDFSNamedClass("swrl:Imp").removeClassListener(this.clsListener);
    }

    public Class getColumnClass(int columnIndex) {
        return String.class;
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int column) {
        if (column == 0) {
            return "Name";
        }
        if (column == 1) {
            return "Expression";
        }
        return null;
    }

    public Icon getIcon(RDFResource resource) {
        return ProtegeUI.getIcon(resource);
    }

    public SWRLImp getImp(int row) {
        return (SWRLImp)this.imps.get(row);
    }

    public RDFProperty getPredicate(int row) {
        return null;
    }

    public RDFResource getRDFResource(int row) {
        return this.getImp(row);
    }

    public RDFResource getSubject() {
        return null;
    }

    private int getRowFor(SWRLImp imp) {
        String impName = imp.getName();
        int i = 0;
        while (i < this.imps.size() && impName.compareToIgnoreCase(this.getImp(i).getName()) >= 0) {
            ++i;
        }
        return i;
    }

    public int getSymbolColumnIndex() {
        return 1;
    }

    public int getRowCount() {
        return this.imps.size();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == this.getSymbolColumnIndex()) {
            return this.getImp(rowIndex).getBrowserText();
        }
        if (columnIndex == 0) {
            return this.getImp(rowIndex).getName();
        }
        return null;
    }

    public int indexOf(SWRLImp imp) {
        return this.imps.indexOf(imp);
    }

    private void initClsListener() {
        this.owlModel.getRDFSNamedClass("swrl:Imp").addClassListener(this.clsListener);
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex == 0 || columnIndex == 1) {
            SWRLImp imp = this.getImp(rowIndex);
            return imp.isEditable();
        }
        return false;
    }

    private boolean isSuitable(SWRLImp imp) {
        if (this.rdfResource == null) {
            return true;
        }
        Set set = imp.getReferencedInstances();
        return set.contains(this.rdfResource);
    }

    private void perhapsAdd(SWRLImp imp) {
        if (this.isSuitable(imp)) {
            int row = this.getRowFor(imp);
            this.imps.add(row, imp);
            this.fireTableRowsInserted(row, row);
        }
    }

    private void perhapsRemove(SWRLImp imp) {
        int row = this.imps.indexOf(imp);
        if (row >= 0) {
            this.imps.remove(row);
            this.fireTableRowsDeleted(row, row);
        }
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        SWRLImp imp = this.getImp(rowIndex);
        if (columnIndex == 1) {
            String text = (String)aValue;
            SWRLParser parser = new SWRLParser(this.owlModel);
            try {
                imp.setExpression(text);
                if (!this.isSuitable(imp)) {
                    ProtegeUI.getModalDialogFactory().showMessageDialog(this.owlModel, "The replacing rule no longer fits the selection\ncriteria of this rules list, and will therefore no\nlonger be visible here.  But no reason to panic: It\nshould still show up on the SWRL tab.");
                }
            }
            catch (Exception exception) {}
        } else if (columnIndex == 0) {
            String newName = (String)aValue;
            if (this.owlModel.isValidResourceName(newName, imp)) {
                RDFResource resource = this.owlModel.getRDFResource(newName);
                if (resource != null) {
                    if (!imp.equals(resource)) {
                        ProtegeUI.getModalDialogFactory().showErrorMessageDialog(this.owlModel, "The name " + newName + " is already used in this ontology.");
                    }
                } else {
                    imp.setName(newName);
                }
            } else {
                ProtegeUI.getModalDialogFactory().showErrorMessageDialog(this.owlModel, String.valueOf(newName) + " is not a valid rule name.");
            }
        }
    }

    public void setRowOf(SWRLImp imp, int index) {
        int oldIndex = this.imps.indexOf(imp);
        this.imps.remove(oldIndex);
        this.fireTableRowsDeleted(oldIndex, oldIndex);
        this.imps.add(index, imp);
        this.fireTableRowsInserted(index, index);
    }

    private void sortImps() {
        Collections.sort(this.imps, new Comparator(){

            public int compare(Object o1, Object o2) {
                SWRLImp a = (SWRLImp)o1;
                SWRLImp b = (SWRLImp)o2;
                return a.getName().compareToIgnoreCase(b.getName());
            }
        });
    }
}

