/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.testing.sanity;

import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.testing.AbstractOWLTest;
import edu.stanford.smi.protegex.owl.testing.AutoRepairableOWLTest;
import edu.stanford.smi.protegex.owl.testing.DefaultOWLTestResult;
import edu.stanford.smi.protegex.owl.testing.OWLTestResult;
import edu.stanford.smi.protegex.owl.testing.RDFPropertyTest;
import java.util.Collections;
import java.util.List;

public class InverseOfInverseFunctionalMustBeFunctionalTest
extends AbstractOWLTest
implements AutoRepairableOWLTest,
RDFPropertyTest {
    public InverseOfInverseFunctionalMustBeFunctionalTest() {
        super("Sanity Tests", null);
    }

    public static boolean fails(RDFProperty property) {
        RDFProperty inverseProperty = property.getInverseProperty();
        if (inverseProperty != null && property instanceof OWLObjectProperty && ((OWLObjectProperty)property).isInverseFunctional()) {
            return !inverseProperty.isFunctional();
        }
        return false;
    }

    public boolean repair(OWLTestResult testResult) {
        OWLProperty property = (OWLProperty)testResult.getHost();
        RDFProperty inverseSlot = property.getInverseProperty();
        inverseSlot.setAllowsMultipleValues(false);
        return true;
    }

    public List test(RDFProperty property) {
        if (InverseOfInverseFunctionalMustBeFunctionalTest.fails(property)) {
            return Collections.singletonList(new DefaultOWLTestResult("The inverse of an inverse functional property should be functional, i.e. it may not have multiple values.", property, 2, this));
        }
        return Collections.EMPTY_LIST;
    }
}

