/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.testing.sanity;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.testing.AbstractOWLTest;
import edu.stanford.smi.protegex.owl.testing.DefaultOWLTestResult;
import edu.stanford.smi.protegex.owl.testing.RDFPropertyTest;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class SubpropertyRangeMustNarrowTest
extends AbstractOWLTest
implements RDFPropertyTest {
    public SubpropertyRangeMustNarrowTest() {
        super("Sanity Tests", "Range of a subproperty can only narrow superproperty");
    }

    public static OWLObjectProperty fails(OWLObjectProperty slot) {
        Collection superslots = slot.getSuperproperties(true);
        if (!superslots.isEmpty()) {
            OWLNamedClass rootCls = slot.getOWLModel().getOWLThingClass();
            Collection range = slot.getUnionRangeClasses();
            if (range.isEmpty()) {
                range = Collections.singleton(rootCls);
            }
            for (Slot superSlot : superslots) {
                if (!(superSlot instanceof OWLObjectProperty)) continue;
                Collection superRange = superSlot.getAllowedClses();
                if (superRange.isEmpty()) {
                    superRange = Collections.singleton(rootCls);
                }
                if (SubpropertyRangeMustNarrowTest.isSubClasses(superRange, range)) continue;
                return (OWLObjectProperty)superSlot;
            }
        }
        return null;
    }

    private static boolean isSubClasses(Collection superRange, Collection subRange) {
        for (Cls subCls : subRange) {
            if (!(subCls instanceof RDFSNamedClass)) continue;
            boolean hasSuperCls = false;
            for (Cls superCls : superRange) {
                if (!(superCls instanceof RDFSNamedClass) || !subCls.equals(superCls) && !subCls.hasSuperclass(superCls)) continue;
                hasSuperCls = true;
                break;
            }
            if (hasSuperCls) continue;
            return false;
        }
        return true;
    }

    public List test(RDFProperty property) {
        OWLObjectProperty failProperty;
        if (property instanceof OWLObjectProperty && (failProperty = SubpropertyRangeMustNarrowTest.fails((OWLObjectProperty)property)) != null) {
            return Collections.singletonList(new DefaultOWLTestResult("The range of " + property.getBrowserText() + " is not a subset of the range of its superproperty " + failProperty.getBrowserText() + ".", property, 2, this));
        }
        return Collections.EMPTY_LIST;
    }
}

