/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.actions;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.refactoring.RefactorResourceAction;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.Component;
import java.awt.event.ActionEvent;

public class SetSubclassesDisjointTrueAction
extends RefactorResourceAction {
    public SetSubclassesDisjointTrueAction() {
        super("Set all subclasses disjoint", OWLIcons.getImageIcon("PrimitiveClassSD"));
    }

    public void actionPerformed(ActionEvent e) {
        OWLModel owlModel = this.getResource().getOWLModel();
        RDFProperty property = owlModel.getProtegeSubclassesDisjointProperty();
        if (property == null) {
            ProtegeUI.getModalDialogFactory().showMessageDialog(owlModel, "Before you can use this feature, you need to import\nthe Protege metadata ontology.  Activate this using\nOWL/Preferences.../Import Protege metadata ontology.");
        } else {
            try {
                try {
                    OWLNamedClass cls = (OWLNamedClass)this.getResource();
                    owlModel.beginTransaction(this.getValue("Name") + " at " + cls.getBrowserText());
                    cls.setSubclassesDisjoint(true);
                    for (RDFSClass subCls : cls.getSubclasses(true)) {
                        if (!(subCls instanceof OWLNamedClass) || !subCls.isEditable()) continue;
                        ((OWLNamedClass)subCls).setSubclassesDisjoint(true);
                    }
                }
                catch (Exception ex) {
                    OWLUI.handleError(owlModel, ex);
                }
            }
            finally {
                owlModel.endTransaction();
            }
        }
    }

    public boolean isSuitable(Component component, RDFResource resource) {
        return resource.isEditable() && resource instanceof OWLNamedClass && !((OWLNamedClass)resource).getSubclassesDisjoint();
    }
}

