/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.cls;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.util.WaitCursor;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.actions.ResourceAction;
import edu.stanford.smi.protegex.owl.ui.cls.ChangeMetaclassAction;
import edu.stanford.smi.protegex.owl.ui.cls.OWLSubclassPane;
import java.awt.Component;
import java.awt.event.ActionEvent;

public class ChangeMetaclassOfSubclassesAction
extends ResourceAction {
    public static String GROUP = "Metaclasses";

    public ChangeMetaclassOfSubclassesAction() {
        super("Change metaclass of subclasses...", Icons.getBlankIcon(), ChangeMetaclassAction.GROUP);
    }

    public void actionPerformed(ActionEvent e) {
        Cls cls = (Cls)this.getResource();
        Cls metaCls = cls.getDirectType();
        String text = "Change metaclass of all subclasses of ";
        text = String.valueOf(text) + cls.getBrowserText();
        text = String.valueOf(text) + " to " + metaCls.getBrowserText();
        OWLModel owlModel = (OWLModel)cls.getKnowledgeBase();
        if (ProtegeUI.getModalDialogFactory().showConfirmDialog(this.getComponent(), text, "Confirm")) {
            WaitCursor waitCursor = new WaitCursor(this.getComponent());
            try {
                for (Cls subclass : cls.getSubclasses()) {
                    if (!subclass.isEditable() || !(subclass instanceof RDFSNamedClass)) continue;
                    subclass.setDirectType(metaCls);
                }
            }
            finally {
                waitCursor.hide();
            }
        }
    }

    public boolean isSuitable(Component component, RDFResource resource) {
        if (component instanceof OWLSubclassPane && ((Cls)resource).getDirectSubclassCount() > 0) {
            Cls cls = (Cls)resource;
            Cls type = cls.getDirectType();
            for (Cls subCls : cls.getDirectSubclasses()) {
                if (!subCls.isVisible() || type.equals(subCls.getDirectType())) continue;
                return true;
            }
        }
        return false;
    }
}

