/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.cls;

import com.hp.hpl.jena.ontology.OntModel;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protegex.owl.database.OWLDatabaseModel;
import edu.stanford.smi.protegex.owl.jena.Jena;
import edu.stanford.smi.protegex.owl.jena.JenaDLConverter;
import edu.stanford.smi.protegex.owl.jena.creator.JenaCreator;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.actions.ResourceAction;
import edu.stanford.smi.protegex.owl.ui.cls.OWLSubclassPane;
import edu.stanford.smi.protegex.owl.ui.widget.ModalProgressBarManager;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.HashSet;
import javax.swing.JFileChooser;

public class ExtractOntologyAction
extends ResourceAction {
    private JFileChooser fileChooser;

    public ExtractOntologyAction() {
        super("Extract (sub) ontology to OWL file...", Icons.getBlankIcon(), "Extract/");
    }

    public void actionPerformed(ActionEvent e) {
        int result = ProtegeUI.getModalDialogFactory().showConfirmCancelDialog(this.getResource().getOWLModel(), "Shall the OWL File be converted to OWL DL if needed?", this.getValue("Name").toString());
        if (result == 4) {
            return;
        }
        HashSet clses = null;
        RDFSNamedClass aClass = (RDFSNamedClass)this.getResource();
        if (!this.getResource().equals(this.getResource().getOWLModel().getOWLThingClass())) {
            clses = new HashSet();
            for (Object c : aClass.getSubclasses(true)) {
                if (!(c instanceof OWLNamedClass) || !((OWLNamedClass)c).isEditable()) continue;
                clses.add(c);
            }
            clses.add(aClass);
        }
        OWLModel owlModel = aClass.getOWLModel();
        JenaCreator creator = new JenaCreator(owlModel, false, clses, new ModalProgressBarManager("Preparing Ontology"));
        OntModel ontModel = creator.createOntModel();
        if (result == 1) {
            System.out.println("Running JenaDLConverter...");
            JenaDLConverter c = new JenaDLConverter(ontModel, owlModel.getNamespaceManager());
            ontModel = c.convertOntModel();
        }
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser(".");
        }
        if (this.fileChooser.showSaveDialog(null) == 0) {
            File file = this.fileChooser.getSelectedFile();
            Jena.saveOntModel(owlModel, file, ontModel, "The (sub) ontology has been extracted to\n" + file);
        }
    }

    public boolean isSuitable(Component component, RDFResource resource) {
        return component instanceof OWLSubclassPane && resource instanceof RDFSNamedClass && resource.getOWLModel() instanceof OWLDatabaseModel;
    }
}

