/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.clsdesc;

import edu.stanford.smi.protege.ui.FrameComparator;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.clsdesc.ClassDescriptionTable;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.owltable.OWLTableModel;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceSelectionAction;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.Component;
import java.util.Arrays;
import java.util.Collection;

class AddRowAction
extends ResourceSelectionAction {
    private ClassDescriptionTable table;
    private boolean thingAllowed;

    AddRowAction(ClassDescriptionTable table, String name, boolean thingAllowed) {
        super(name, OWLIcons.getAddIcon("PrimitiveClass"), true);
        this.table = table;
        this.thingAllowed = thingAllowed;
    }

    public void resourceSelected(RDFResource resource) {
        OWLModel owlModel = resource.getOWLModel();
        try {
            try {
                owlModel.beginTransaction(this.getValue("Name") + " " + resource.getBrowserText() + " to " + this.table.getEditedCls().getBrowserText());
                this.table.addCls((RDFSClass)resource);
            }
            catch (Exception ex) {
                OWLUI.handleError(owlModel, ex);
            }
        }
        finally {
            owlModel.endTransaction();
        }
    }

    public Collection getSelectableResources() {
        OWLModel owlModel = this.table.getOWLModel();
        Collection clses = owlModel.getUserDefinedOWLNamedClasses();
        if (this.thingAllowed) {
            clses.add(owlModel.getOWLThingClass());
        }
        OWLNamedClass editedCls = ((OWLTableModel)this.table.getModel()).getEditedCls();
        clses.remove(editedCls);
        Object[] cs = clses.toArray();
        Arrays.sort(cs, new FrameComparator());
        return Arrays.asList(cs);
    }

    public Collection pickResources() {
        return ProtegeUI.getSelectionDialogFactory().selectClasses((Component)((Object)this.table), this.table.getOWLModel(), "Select named class(es) to add");
    }
}

