/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.clsproperties;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLCardinalityBase;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLRestriction;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.event.PropertyValueAdapter;
import edu.stanford.smi.protegex.owl.model.event.PropertyValueListener;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.clsproperties.OldRestrictionTreeNode;
import edu.stanford.smi.protegex.owl.ui.clsproperties.PropertyRestrictionsTree;
import edu.stanford.smi.protegex.owl.ui.clsproperties.RestrictionTreeNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class PropertyTreeNode
extends DefaultMutableTreeNode
implements Comparable,
Disposable {
    private OWLNamedClass cls;
    private boolean inherited;
    private PropertyRestrictionsTree tree;
    private PropertyValueListener valueListener = new PropertyValueAdapter(){

        public void propertyValueChanged(RDFResource resource, RDFProperty property, Collection oldValues) {
            PropertyTreeNode.this.tree.refillLater();
        }
    };

    public PropertyTreeNode(PropertyRestrictionsTree tree, OWLNamedClass cls, RDFProperty property, boolean inherited) {
        this.setUserObject(property);
        this.inherited = inherited;
        this.cls = cls;
        this.tree = tree;
        this.addChildNodes();
        property.addPropertyValueListener(this.valueListener);
    }

    private void addChildNodes() {
        List restrictions = this.getRestrictions();
        for (OWLRestriction restriction : restrictions) {
            OWLAnonymousClass expressionRoot = restriction.getExpressionRoot();
            Collection subclasses = expressionRoot.getSubclasses(false);
            RDFSClass inheritedFromClass = (RDFSClass)subclasses.iterator().next();
            if (this.cls.equals(inheritedFromClass)) {
                inheritedFromClass = null;
            }
            OldRestrictionTreeNode node = new OldRestrictionTreeNode(this.tree, restriction, inheritedFromClass);
            this.add(node);
        }
    }

    public int compareTo(Object o) {
        PropertyTreeNode other = (PropertyTreeNode)o;
        if (!this.isInherited()) {
            if (other.isInherited()) {
                return -1;
            }
        } else {
            if (!other.isInherited()) {
                return 1;
            }
            if (this.getChildCount() > 0) {
                if (other.getChildCount() == 0) {
                    return -1;
                }
            } else if (other.getChildCount() > 0) {
                return 1;
            }
        }
        return this.getRDFProperty().compareTo(other.getRDFProperty());
    }

    public void dispose() {
        int i = 0;
        while (i < this.getChildCount()) {
            this.getRestrictionTreeNode(i).dispose();
            ++i;
        }
        this.getRDFProperty().removePropertyValueListener(this.valueListener);
    }

    private List getRestrictions() {
        ArrayList rs = new ArrayList();
        ArrayList<RDFSClass> queue = new ArrayList<RDFSClass>();
        queue.add(this.cls);
        HashSet<OWLNamedClass> reachedClses = new HashSet<OWLNamedClass>();
        HashSet overloadedClses = new HashSet();
        boolean first = true;
        while (!queue.isEmpty()) {
            OWLNamedClass c = (OWLNamedClass)queue.get(0);
            reachedClses.add(c);
            queue.remove(0);
            for (RDFSClass superClass : c.getSuperclasses(false)) {
                if (superClass instanceof OWLRestriction) {
                    this.perhapsAddRestriction((OWLRestriction)superClass, rs, overloadedClses);
                    continue;
                }
                if (superClass instanceof OWLIntersectionClass) {
                    OWLIntersectionClass intersectionClass = (OWLIntersectionClass)superClass;
                    for (RDFSClass operand : intersectionClass.getOperands()) {
                        if (!(operand instanceof OWLRestriction)) continue;
                        this.perhapsAddRestriction((OWLRestriction)operand, rs, overloadedClses);
                    }
                    continue;
                }
                if (!(superClass instanceof OWLNamedClass) || reachedClses.contains(superClass)) continue;
                queue.add(superClass);
            }
            if (!first) continue;
            Collections.sort(rs, new Comparator(){

                public int compare(Object o1, Object o2) {
                    RDFSClass directType1 = ((OWLRestriction)o1).getProtegeType();
                    RDFSClass directType2 = ((OWLRestriction)o2).getProtegeType();
                    return directType1.getName().compareTo(directType2.getName());
                }
            });
            first = false;
        }
        this.removeOverloadedAllRestrictions(rs);
        return rs;
    }

    public Icon getIcon() {
        RDFProperty property = this.getRDFProperty();
        if (this.isInherited()) {
            return property.getInheritedIcon();
        }
        return ProtegeUI.getIcon(property);
    }

    public RDFProperty getRDFProperty() {
        return (RDFProperty)this.getUserObject();
    }

    public OWLNamedClass getRestrictedClass() {
        return this.cls;
    }

    public RestrictionTreeNode getRestrictionTreeNode(int index) {
        return (RestrictionTreeNode)this.getChildAt(index);
    }

    public OldRestrictionTreeNode getRestrictionTreeNode(OWLRestriction restriction) {
        int i = 0;
        while (i < this.getChildCount()) {
            OldRestrictionTreeNode node = (OldRestrictionTreeNode)this.getChildAt(i);
            if (node.getRestriction().equals(restriction)) {
                return node;
            }
            ++i;
        }
        return null;
    }

    public OldRestrictionTreeNode getRestrictionTreeNode(String restrictionText) {
        int i = 0;
        while (i < this.getChildCount()) {
            OldRestrictionTreeNode node;
            TreeNode child = this.getChildAt(i);
            if (child instanceof OldRestrictionTreeNode && (node = (OldRestrictionTreeNode)child).getRestriction().getBrowserText().equals(restrictionText)) {
                return node;
            }
            ++i;
        }
        return null;
    }

    public boolean isInherited() {
        return this.inherited;
    }

    public boolean hasRestrictionOfType(Cls metaCls) {
        int i = 0;
        while (i < this.getChildCount()) {
            if (metaCls.equals(this.getRestrictionTreeNode(i).getRestrictionMetaCls())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void perhapsAddRestriction(OWLRestriction restriction, List rs, Set overloadedClses) {
        OWLSomeValuesFrom someValuesFrom;
        String browserText = restriction.getBrowserText();
        for (OWLRestriction owlRestriction : rs) {
            if (!browserText.equals(owlRestriction.getBrowserText())) continue;
            return;
        }
        if (restriction instanceof OWLSomeValuesFrom && (someValuesFrom = (OWLSomeValuesFrom)restriction).getSomeValuesFrom() instanceof RDFSNamedClass) {
            RDFSNamedClass namedClass = (RDFSNamedClass)someValuesFrom.getSomeValuesFrom();
            for (OWLRestriction owlRestriction : rs) {
                RDFSNamedClass subclass;
                OWLSomeValuesFrom other;
                if (!(owlRestriction instanceof OWLSomeValuesFrom) || !((other = (OWLSomeValuesFrom)owlRestriction).getSomeValuesFrom() instanceof RDFSNamedClass) || !(subclass = (RDFSNamedClass)other.getSomeValuesFrom()).getSuperclasses(true).contains(namedClass)) continue;
                return;
            }
        }
        if (this.getRDFProperty().equals(restriction.getOnProperty())) {
            boolean isQCR = false;
            if (restriction instanceof OWLCardinalityBase) {
                OWLCardinalityBase base = (OWLCardinalityBase)restriction;
                isQCR = base.isQualified();
            }
            if (isQCR) {
                rs.add(restriction);
            } else if (!overloadedClses.contains(restriction.getProtegeType())) {
                if (restriction instanceof OWLCardinalityBase) {
                    overloadedClses.add(restriction.getProtegeType());
                }
                rs.add(restriction);
            }
        }
    }

    private void removeOverloadedAllRestrictions(List rs) {
        boolean changed = false;
        do {
            int i = 0;
            while (i < rs.size()) {
                OWLRestriction restriction = (OWLRestriction)rs.get(i);
                if (restriction instanceof OWLAllValuesFrom && ((OWLAllValuesFrom)restriction).getFiller() instanceof RDFSClass) {
                    this.removeOverloadedAllRestrictions(rs, i);
                }
                ++i;
            }
        } while (changed);
    }

    private boolean removeOverloadedAllRestrictions(List rs, int index) {
        boolean changed = false;
        OWLAllValuesFrom allRestriction = (OWLAllValuesFrom)rs.get(index);
        RDFSClass superFiller = (RDFSClass)allRestriction.getFiller();
        OWLNamedClass superCls = allRestriction.getOwner();
        int i = index + 1;
        while (i < rs.size()) {
            OWLRestriction restriction = (OWLRestriction)rs.get(i);
            if (restriction instanceof OWLAllValuesFrom && restriction.getOnProperty().equals(allRestriction.getOnProperty())) {
                OWLAllValuesFrom a = (OWLAllValuesFrom)restriction;
                RDFSClass subFiller = (RDFSClass)a.getFiller();
                OWLNamedClass andir = a.getOwner();
                if (a.getFiller() instanceof RDFSClass && superFiller.isSubclassOf(subFiller) && !andir.equals(superCls)) {
                    rs.remove(i);
                    changed = true;
                }
            }
            ++i;
        }
        return changed;
    }
}

