/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.clsproperties;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.clsproperties.CreatePropertyAction;
import edu.stanford.smi.protegex.owl.ui.clsproperties.RDFPropertiesTable;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceSelectionAction;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class RDFPropertiesComponent
extends JPanel {
    private Action addPropertyAction = new ResourceSelectionAction("Add property...", OWLIcons.getAddIcon("RDFProperty")){

        public Collection getSelectableResources() {
            ArrayList allowedProperties = new ArrayList(RDFPropertiesComponent.this.cls.getOWLModel().getUserDefinedRDFProperties());
            allowedProperties.removeAll(RDFPropertiesComponent.this.cls.getUnionDomainProperties());
            return allowedProperties;
        }

        public RDFResource pickResource() {
            return ProtegeUI.getSelectionDialogFactory().selectProperty(RDFPropertiesComponent.this, RDFPropertiesComponent.this.cls.getOWLModel(), this.getSelectableResources(), "Select a property to add");
        }

        public void resourceSelected(RDFResource resource) {
            RDFPropertiesComponent.this.table.handleAddProperty((RDFProperty)resource);
        }
    };
    private RDFSNamedClass cls;
    private Action removePropertiesAction = new AbstractAction("Remove selected properties", OWLIcons.getRemoveIcon("RDFProperty")){

        public void actionPerformed(ActionEvent e) {
            RDFPropertiesComponent.this.table.handleRemoveProperties();
        }
    };
    private RDFPropertiesTable table = new RDFPropertiesTable();

    public RDFPropertiesComponent(OWLModel owlModel) {
        JScrollPane sp = new JScrollPane(this.table);
        sp.getViewport().setBackground(Color.white);
        OWLLabeledComponent lc = new OWLLabeledComponent("Properties", sp);
        CreatePropertyAction.addActions(lc, owlModel, new CreatePropertyAction.CallBack(){

            public void propertyCreated(RDFProperty property) {
                RDFPropertiesComponent.this.table.handlePropertyCreated(property);
            }
        });
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                RDFPropertiesComponent.this.updateActions();
            }
        });
        lc.addHeaderButton(this.addPropertyAction);
        lc.addHeaderButton(this.removePropertiesAction);
        this.setLayout(new BorderLayout());
        this.add("Center", (Component)((Object)lc));
        this.updateActions();
    }

    public void setClass(RDFSNamedClass cls) {
        this.cls = cls;
        this.table.setClass(cls);
    }

    private void updateActions() {
        boolean enabled = false;
        int[] rows = this.table.getSelectedRows();
        if (rows.length > 0) {
            enabled = true;
            int i = 0;
            while (i < rows.length) {
                int row = rows[i];
                if (!this.table.getTableModel().isDirectProperty(row)) {
                    enabled = false;
                    break;
                }
                ++i;
            }
        }
        this.removePropertiesAction.setEnabled(enabled);
    }
}

