/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.clsproperties.tests;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLCardinality;
import edu.stanford.smi.protegex.owl.model.OWLHasValue;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import edu.stanford.smi.protegex.owl.ui.clsproperties.PropertyRestrictionsTree;
import edu.stanford.smi.protegex.owl.ui.clsproperties.PropertyTreeNode;
import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class PropertyRestrictionsTreeTestCase
extends AbstractJenaTestCase {
    private void assertTree(PropertyRestrictionsTree tree, Object[] objects) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)tree.getModel().getRoot();
        Enumeration<TreeNode> enumeration = root.preorderEnumeration();
        enumeration.nextElement();
        int i = 0;
        i = 0;
        while (i < objects.length && enumeration.hasMoreElements()) {
            Object object = objects[i];
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)enumeration.nextElement();
            if (!object.equals(node.getUserObject())) {
                this.printErrorTree(root);
            }
            PropertyRestrictionsTreeTestCase.assertEquals((Object)object, (Object)node.getUserObject());
            ++i;
        }
        if (enumeration.hasMoreElements()) {
            this.printErrorTree(root);
        }
        if (i < objects.length) {
            this.printErrorTree(root);
        }
        PropertyRestrictionsTreeTestCase.assertFalse((enumeration.hasMoreElements() || i < objects.length ? 1 : 0) != 0);
    }

    private void printErrorTree(DefaultMutableTreeNode root) {
        System.out.println("Structure of failed tree:");
        Enumeration<TreeNode> e = root.preorderEnumeration();
        e.nextElement();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode next = (DefaultMutableTreeNode)e.nextElement();
            Object obj = next.getUserObject();
            System.out.println(" - " + (obj instanceof Frame ? ((Frame)obj).getBrowserText() : obj.toString()));
        }
    }

    public void testSimpleBuild() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Parent");
        OWLObjectProperty hasChildrenProperty = this.owlModel.createOWLObjectProperty("hasChildren");
        hasChildrenProperty.addUnionDomainClass(cls);
        OWLMinCardinality restriction = this.owlModel.createOWLMinCardinality(hasChildrenProperty, 1);
        cls.addSuperclass(restriction);
        PropertyRestrictionsTree tree = new PropertyRestrictionsTree(this.owlModel, cls);
        this.assertTree(tree, new Object[]{hasChildrenProperty, restriction});
        PropertyTreeNode[] propertyTreeNodes = tree.getPropertyTreeNodes();
        PropertyRestrictionsTreeTestCase.assertEquals((int)1, (int)propertyTreeNodes.length);
        PropertyRestrictionsTreeTestCase.assertEquals((Object)hasChildrenProperty, (Object)propertyTreeNodes[0].getRDFProperty());
        PropertyRestrictionsTreeTestCase.assertFalse((boolean)propertyTreeNodes[0].isInherited());
        PropertyRestrictionsTreeTestCase.assertEquals((int)1, (int)propertyTreeNodes[0].getChildCount());
        PropertyRestrictionsTreeTestCase.assertEquals((Object)restriction, (Object)propertyTreeNodes[0].getRestrictionTreeNode(0).getUserObject());
    }

    public void testRecurseIntoSuperclassesAndEquivalentClasses() {
        OWLNamedClass superClass = this.owlModel.createOWLNamedClass("Super");
        OWLObjectProperty superproperty = this.owlModel.createOWLObjectProperty("super");
        superproperty.setDomain(superClass);
        OWLNamedClass middleClass = this.owlModel.createOWLNamedSubclass("Middle", superClass);
        OWLObjectProperty middleProperty = this.owlModel.createOWLObjectProperty("middle");
        middleProperty.setDomain(middleClass);
        OWLNamedClass subClass = this.owlModel.createOWLNamedSubclass("Sub", middleClass);
        OWLObjectProperty subProperty = this.owlModel.createOWLObjectProperty("sub");
        subProperty.setDomain(subClass);
        OWLNamedClass otherClass = this.owlModel.createOWLNamedClass("Other");
        OWLObjectProperty otherProperty = this.owlModel.createOWLObjectProperty("other");
        otherProperty.setDomain(otherClass);
        OWLIntersectionClass intersectionClass = this.owlModel.createOWLIntersectionClass();
        OWLMinCardinality restriction = this.owlModel.createOWLMinCardinality(otherProperty, 1);
        intersectionClass.addOperand(otherClass);
        intersectionClass.addOperand(restriction);
        subClass.addSuperclass(otherClass);
        subClass.addEquivalentClass(intersectionClass);
        this.assertTree(new PropertyRestrictionsTree(this.owlModel, subClass), new Object[]{subProperty, otherProperty, restriction, middleProperty, superproperty});
    }

    public void testDuplicateProperty() {
        OWLNamedClass superCls = this.owlModel.createOWLNamedClass("Super");
        OWLObjectProperty superproperty = this.owlModel.createOWLObjectProperty("super");
        superproperty.setDomain(superCls);
        OWLNamedClass subCls = this.owlModel.createOWLNamedSubclass("Sub", superCls);
        superproperty.addUnionDomainClass(subCls);
        this.assertTree(new PropertyRestrictionsTree(this.owlModel, subCls), new Object[]{superproperty});
    }

    public void testOverloadedMinCardiRestrictionWithMinCardiRestriction() {
        OWLNamedClass superclass = this.owlModel.createOWLNamedClass("Super");
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        property.addUnionDomainClass(superclass);
        OWLMinCardinality superRestriction = this.owlModel.createOWLMinCardinality(property, 1);
        superclass.addSuperclass(superRestriction);
        this.assertTree(new PropertyRestrictionsTree(this.owlModel, superclass), new Object[]{property, superRestriction});
        OWLNamedClass subclass = this.owlModel.createOWLNamedSubclass("Sub", superclass);
        OWLMinCardinality subRestriction = this.owlModel.createOWLMinCardinality(property, 2);
        subclass.addSuperclass(subRestriction);
        this.assertTree(new PropertyRestrictionsTree(this.owlModel, subclass), new Object[]{property, subRestriction});
    }

    public void testOverloadedCardiRestrictionWithMinCardiRestriction() {
        OWLNamedClass superclass = this.owlModel.createOWLNamedClass("Super");
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        property.addUnionDomainClass(superclass);
        OWLCardinality superRestriction = this.owlModel.createOWLCardinality(property, 1);
        superclass.addSuperclass(superRestriction);
        this.assertTree(new PropertyRestrictionsTree(this.owlModel, superclass), new Object[]{property, superRestriction});
        OWLNamedClass subclass = this.owlModel.createOWLNamedSubclass("Sub", superclass);
        OWLMinCardinality subRestriction = this.owlModel.createOWLMinCardinality(property, 2);
        subclass.addSuperclass(subRestriction);
        this.assertTree(new PropertyRestrictionsTree(this.owlModel, subclass), new Object[]{property, subRestriction, superRestriction});
    }

    public void testAllRestrictionOverloaded() {
        OWLNamedClass superclass = this.owlModel.createOWLNamedClass("Super");
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        property.addUnionDomainClass(superclass);
        OWLAllValuesFrom superRestriction = this.owlModel.createOWLAllValuesFrom((RDFProperty)property, superclass);
        superclass.addSuperclass(superRestriction);
        this.assertTree(new PropertyRestrictionsTree(this.owlModel, superclass), new Object[]{property, superRestriction});
        OWLNamedClass subclass = this.owlModel.createOWLNamedSubclass("Sub", superclass);
        OWLAllValuesFrom subRestriction = this.owlModel.createOWLAllValuesFrom((RDFProperty)property, subclass);
        subclass.addSuperclass(subRestriction);
        this.assertTree(new PropertyRestrictionsTree(this.owlModel, subclass), new Object[]{property, subRestriction});
    }

    public void testAllRestrictionMultiInherited() {
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        property.setDomainDefined(false);
        OWLNamedClass superCls1 = this.owlModel.createOWLNamedClass("Super1");
        OWLAllValuesFrom superRestriction1 = this.owlModel.createOWLAllValuesFrom((RDFProperty)property, superCls1);
        superCls1.addSuperclass(superRestriction1);
        OWLNamedClass superCls2 = this.owlModel.createOWLNamedClass("Super2");
        OWLAllValuesFrom superRestriction2 = this.owlModel.createOWLAllValuesFrom((RDFProperty)property, superCls2);
        superCls2.addSuperclass(superRestriction2);
        OWLNamedClass subCls = this.owlModel.createOWLNamedSubclass("Sub", superCls1);
        this.assertTree(new PropertyRestrictionsTree(this.owlModel, subCls), new Object[]{property, superRestriction1});
        subCls.addSuperclass(superCls2);
        this.assertTree(new PropertyRestrictionsTree(this.owlModel, subCls), new Object[]{property, superRestriction1, superRestriction2});
    }

    public void testOverloadedHasRestriction() {
        OWLNamedClass superclass = this.owlModel.createOWLNamedClass("Super");
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        property.addUnionDomainClass(superclass);
        OWLHasValue superRestriction = this.owlModel.createOWLHasValue(property, superclass);
        superclass.addSuperclass(superRestriction);
        this.assertTree(new PropertyRestrictionsTree(this.owlModel, superclass), new Object[]{property, superRestriction});
        OWLNamedClass subclass = this.owlModel.createOWLNamedSubclass("Sub", superclass);
        OWLHasValue subRestriction = this.owlModel.createOWLHasValue(property, subclass);
        subclass.addSuperclass(subRestriction);
        this.assertTree(new PropertyRestrictionsTree(this.owlModel, subclass), new Object[]{property, subRestriction, superRestriction});
    }

    public void testOverloadedSomeRestriction() {
        OWLNamedClass superclass = this.owlModel.createOWLNamedClass("Super");
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        property.setDomain(superclass);
        OWLSomeValuesFrom superRestriction = this.owlModel.createOWLSomeValuesFrom((RDFProperty)property, superclass);
        superclass.addSuperclass(superRestriction);
        this.assertTree(new PropertyRestrictionsTree(this.owlModel, superclass), new Object[]{property, superRestriction});
        OWLNamedClass subCls = this.owlModel.createOWLNamedSubclass("Sub", superclass);
        OWLSomeValuesFrom subRestriction = this.owlModel.createOWLSomeValuesFrom((RDFProperty)property, subCls);
        subCls.addSuperclass(subRestriction);
        this.assertTree(new PropertyRestrictionsTree(this.owlModel, subCls), new Object[]{property, subRestriction});
    }

    public void testShowDomainlessPropertiesOnlyIfRestricted() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Cls");
        OWLObjectProperty localProperty = this.owlModel.createOWLObjectProperty("local");
        localProperty.setDomain(cls);
        OWLObjectProperty globalProperty = this.owlModel.createOWLObjectProperty("global");
        globalProperty.setDomainDefined(false);
        this.assertTree(new PropertyRestrictionsTree(this.owlModel, cls), new Object[]{localProperty});
        OWLMinCardinality restriction = this.owlModel.createOWLMinCardinality(globalProperty, 1);
        cls.addSuperclass(restriction);
        this.assertTree(new PropertyRestrictionsTree(this.owlModel, cls), new Object[]{localProperty, globalProperty, restriction});
    }

    public void testSubproperties() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Cls");
        OWLObjectProperty superproperty = this.owlModel.createOWLObjectProperty("superproperty");
        superproperty.setDomain(cls);
        OWLObjectProperty subproperty = (OWLObjectProperty)this.owlModel.createSubproperty("subproperty", superproperty);
        PropertyRestrictionsTreeTestCase.assertFalse((boolean)subproperty.isDomainDefined());
        this.assertTree(new PropertyRestrictionsTree(this.owlModel, cls), new Object[]{superproperty, subproperty});
    }

    public void testDomainlessSubproperties() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Cls");
        OWLObjectProperty superproperty = this.owlModel.createOWLObjectProperty("superproperty");
        superproperty.setDomainDefined(false);
        OWLObjectProperty subPropertyWithout = (OWLObjectProperty)this.owlModel.createSubproperty("subPropertyWithout", superproperty);
        OWLObjectProperty subPropertyWith = (OWLObjectProperty)this.owlModel.createSubproperty("subPropertyWith", superproperty);
        OWLMinCardinality minCardiRestriction = this.owlModel.createOWLMinCardinality(subPropertyWith, 1);
        cls.addSuperclass(minCardiRestriction);
        PropertyRestrictionsTreeTestCase.assertFalse((boolean)subPropertyWithout.isDomainDefined());
        PropertyRestrictionsTreeTestCase.assertFalse((boolean)subPropertyWith.isDomainDefined());
        this.assertTree(new PropertyRestrictionsTree(this.owlModel, cls), new Object[]{subPropertyWith, minCardiRestriction});
    }
}

