/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.components.annotations;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.project.SettingsMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class DefaultAnnotations {
    public static final String SETTINGS_MAP_KEY = DefaultAnnotations.class.getName();
    private OWLModel owlModel;

    public DefaultAnnotations(OWLModel owlModel) {
        this.owlModel = owlModel;
    }

    public void addDefaultAnnotationProperty(RDFProperty property) {
        this.getSettingsMap().setBoolean(property.getName(), true);
    }

    public Collection getDefaultAnnotationProperties() {
        SettingsMap map = this.getSettingsMap();
        ArrayList<RDFResource> results = new ArrayList<RDFResource>();
        Iterator names = map.listKeys();
        while (names.hasNext()) {
            String name = (String)names.next();
            RDFResource resource = this.owlModel.getRDFResource(name);
            if (!(resource instanceof RDFProperty)) continue;
            results.add(resource);
        }
        return results;
    }

    private SettingsMap getSettingsMap() {
        return this.owlModel.getOWLProject().getSettingsMap().getSettingsMap(SETTINGS_MAP_KEY);
    }

    public void removeDefaultAnnotationProperty(RDFProperty property) {
        this.getSettingsMap().remove(property.getName());
    }

    public void setDefaultAnnotationProperties(Collection properties) {
        this.owlModel.getOWLProject().getSettingsMap().remove(SETTINGS_MAP_KEY);
        SettingsMap newMap = this.getSettingsMap();
        for (RDFProperty property : properties) {
            newMap.setBoolean(property.getName(), true);
        }
    }
}

