/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.conditions.tests;

import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import edu.stanford.smi.protegex.owl.ui.conditions.ConditionsTableConstants;
import edu.stanford.smi.protegex.owl.ui.conditions.ConditionsTableModel;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public abstract class AbstractConditionsTableTestCase
extends AbstractJenaTestCase
implements ConditionsTableConstants {
    protected List events = new ArrayList();
    protected static final String SUFFICIENT = "SUFFICIENT";
    protected static final Integer NECESSARY = new Integer(-1);
    protected static final Integer INHERITED = new Integer(-2);

    protected void assertTableModelStructure(ConditionsTableModel tableModel, Object[] structure) {
        AbstractConditionsTableTestCase.assertEquals((String)"Unexpected tableModel size", (int)structure.length, (int)tableModel.getRowCount());
        int i = 0;
        while (i < structure.length) {
            Object o = structure[i];
            if (o == null) {
                AbstractConditionsTableTestCase.assertTrue((String)("Separator expected at row " + i), (boolean)tableModel.isSeparator(i));
            } else if (o.equals(SUFFICIENT)) {
                AbstractConditionsTableTestCase.assertTrue((String)("Sufficient separator expected at row " + i), (tableModel.isSeparator(i) && tableModel.isDefinition(i) ? 1 : 0) != 0);
            } else if (o instanceof Integer) {
                AbstractConditionsTableTestCase.assertTrue((String)("Separator of " + o + " expected at row " + i), (tableModel.isSeparator(i) && tableModel.getType(i) == ((Integer)o).intValue() ? 1 : 0) != 0);
            } else if (o instanceof Class) {
                Class c = (Class)o;
                AbstractConditionsTableTestCase.assertTrue((String)(String.valueOf(c.getName()) + " expected at row " + i), (boolean)c.isAssignableFrom(tableModel.getClass(i).getClass()));
            } else {
                AbstractConditionsTableTestCase.assertEquals((String)(o + " expected at row " + i), (Object)o, (Object)tableModel.getClass(i));
            }
            ++i;
        }
    }

    protected TableModelEvent getEvent(int index) {
        return (TableModelEvent)this.events.get(index);
    }

    protected ConditionsTableModel getTableModel(OWLNamedClass hostCls) {
        this.events.clear();
        ConditionsTableModel tableModel = new ConditionsTableModel(hostCls, this.owlModel.getSlot(":DIRECT-SUPERCLASSES"));
        tableModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                AbstractConditionsTableTestCase.this.events.add(e);
            }
        });
        return tableModel;
    }
}

