/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.forms;

import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.widget.ClsWidget;
import edu.stanford.smi.protege.widget.SlotWidget;
import edu.stanford.smi.protegex.owl.jena.Jena;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.ui.forms.AbsoluteLayoutNames;
import edu.stanford.smi.protegex.owl.ui.forms.DefaultWidgetClassMapper;
import edu.stanford.smi.protegex.owl.ui.forms.FormsNames;
import edu.stanford.smi.protegex.owl.ui.forms.ProtegeFormsNames;
import edu.stanford.smi.protegex.owl.ui.forms.WidgetClassMapper;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class AbsoluteFormsGenerator {
    private static final Set ignoreSystemClasses = new HashSet();
    public static boolean optional;
    public static final String SAVE_FORMS_KEY;
    public static final String ALL = "all";
    public static final String MODIFIED = "modified";
    private OWLModel owlModel;
    private Project project;
    private WidgetClassMapper widgetClassMapper = new DefaultWidgetClassMapper();
    public static final String SUFFIX = ".forms";
    public static final String FILE_NAME = "protege-system.forms";
    public static final String PROTEGE_SYSTEM_FORMS_URI = "http://www.owl-ontologies.com/forms/protege-system.forms";

    static {
        ignoreSystemClasses.add("owl:AllDifferent");
        ignoreSystemClasses.add("owl:AllValuesFromRestriction");
        ignoreSystemClasses.add("owl:AnnotationProperty");
        ignoreSystemClasses.add(":OWL-ANONYMOUS-ROOT");
        ignoreSystemClasses.add("owl:CardinalityRestriction");
        ignoreSystemClasses.add("owl:ComplementClass");
        ignoreSystemClasses.add("owl:DataRange");
        ignoreSystemClasses.add("owl:DeprecatedClass");
        ignoreSystemClasses.add("owl:DeprecatedProperty");
        ignoreSystemClasses.add("owl:EnumeratedClass");
        ignoreSystemClasses.add("owl:FunctionalProperty");
        ignoreSystemClasses.add("owl:HasValueRestriction");
        ignoreSystemClasses.add("owl:IntersectionClass");
        ignoreSystemClasses.add("owl:InverseFunctionalProperty");
        ignoreSystemClasses.add("owl:LogicalClass");
        ignoreSystemClasses.add("owl:MaxCardinalityRestriction");
        ignoreSystemClasses.add("owl:MinCardinalityRestriction");
        ignoreSystemClasses.add("owl:Nothing");
        ignoreSystemClasses.add("owl:Restriction");
        ignoreSystemClasses.add("owl:SomeValuesFromRestriction");
        ignoreSystemClasses.add("owl:SymmetricProperty");
        ignoreSystemClasses.add("owl:TransitiveProperty");
        ignoreSystemClasses.add("owl:UnionClass");
        ignoreSystemClasses.add("rdf:Alt");
        ignoreSystemClasses.add("rdf:Bag");
        ignoreSystemClasses.add("rdf:Description");
        ignoreSystemClasses.add("rdf:List");
        ignoreSystemClasses.add("rdf:Seq");
        ignoreSystemClasses.add("rdf:Statement");
        ignoreSystemClasses.add("rdfs:Container");
        ignoreSystemClasses.add("rdfs:Literal");
        optional = true;
        SAVE_FORMS_KEY = String.valueOf(AbsoluteFormsGenerator.class.getName()) + ".saveForms";
    }

    public AbsoluteFormsGenerator(OWLModel owlModel) {
        this.owlModel = owlModel;
        this.project = owlModel.getProject();
    }

    private void createFormWidget(Model model, RDFSNamedClass cls, boolean all) {
        ClsWidget widget;
        if ((all || this.project.hasCustomizedDescriptor((Cls)cls)) && (widget = this.project.getDesignTimeClsWidget((Cls)cls)) != null && !cls.getName().startsWith("protege:")) {
            this.createFormWidget(model, cls, widget);
        }
    }

    private void createFormWidget(Model model, RDFSNamedClass cls, ClsWidget clsWidget) {
        String baseURI = model.getNsPrefixURI("");
        String formName = cls.getName().replace(':', '_');
        Resource formWidget = model.createResource(String.valueOf(baseURI) + formName, (Resource)FormsNames.FormWidget);
        formWidget.addProperty((Property)FormsNames.forClass, (RDFNode)model.createResource(cls.getURI()));
        for (Slot slot : this.owlModel.getSlots()) {
            SlotWidget slotWidget = clsWidget.getSlotWidget(slot);
            if (slotWidget == null) continue;
            String widgetClassName = slotWidget.getDescriptor().getWidgetClassName();
            String typeURI = this.widgetClassMapper.getWidgetClassURI(widgetClassName);
            OntClass type = FormsNames.Widget;
            if (typeURI != null) {
                type = model.createResource(typeURI);
            }
            Resource widget = model.createResource(null, (Resource)type);
            formWidget.addProperty((Property)FormsNames.widgets, (RDFNode)widget);
            if (slot instanceof RDFProperty) {
                RDFProperty property = (RDFProperty)slot;
                String prefix = property.getNamespace();
                if (prefix != null) {
                    widget.addProperty((Property)FormsNames.forProperty, (RDFNode)model.createResource(property.getURI()));
                }
            } else {
                widget.addProperty(RDFS.comment, slot.getName());
            }
            if (type.equals((Object)FormsNames.Widget)) {
                widget.addProperty((Property)ProtegeFormsNames.javaClassName, widgetClassName);
            }
            Resource layoutData = model.createResource(null, (Resource)AbsoluteLayoutNames.AbsoluteLayoutData);
            widget.addProperty((Property)FormsNames.layoutData, (RDFNode)layoutData);
            Rectangle bounds = slotWidget.getDescriptor().getBounds();
            layoutData.addProperty((Property)AbsoluteLayoutNames.x, (RDFNode)model.createLiteral((long)((int)bounds.getX())));
            layoutData.addProperty((Property)AbsoluteLayoutNames.y, (RDFNode)model.createLiteral((long)((int)bounds.getY())));
            layoutData.addProperty((Property)AbsoluteLayoutNames.width, (RDFNode)model.createLiteral((long)((int)bounds.getWidth())));
            layoutData.addProperty((Property)AbsoluteLayoutNames.height, (RDFNode)model.createLiteral((long)((int)bounds.getHeight())));
        }
    }

    public Model createModel(TripleStore ts, boolean all) {
        Model model = ModelFactory.createDefaultModel();
        String baseURI = this.getFormsFileURI(ts);
        model.setNsPrefix("", String.valueOf(baseURI) + "#");
        model.setNsPrefix("owl", "http://www.w3.org/2002/07/owl#");
        model.setNsPrefix("rdf", RDF.getURI());
        model.setNsPrefix("rdfs", RDFS.getURI());
        model.setNsPrefix("forms", "http://www.owl-ontologies.com/forms/forms.owl#");
        model.setNsPrefix("absolute", "http://www.owl-ontologies.com/forms/absolute.owl#");
        model.setNsPrefix("pforms", "http://www.owl-ontologies.com/forms/protege.owl#");
        Resource ontology = model.createResource(baseURI);
        ontology.addProperty(RDF.type, (RDFNode)OWL.Ontology);
        String pns = "http://www.owl-ontologies.com/forms/protege.owl#";
        String ans = "http://www.owl-ontologies.com/forms/absolute.owl#";
        ontology.addProperty(OWL.imports, (RDFNode)model.createResource(pns.substring(0, pns.length() - 1)));
        ontology.addProperty(OWL.imports, (RDFNode)model.createResource(ans.substring(0, ans.length() - 1)));
        if (ts == this.owlModel.getTripleStoreModel().getTripleStore(0)) {
            for (Cls cls : this.owlModel.getClses()) {
                if (!cls.isSystem() || !(cls instanceof RDFSNamedClass) || ignoreSystemClasses.contains(cls.getName())) continue;
                RDFSNamedClass c = (RDFSNamedClass)cls;
                this.createFormWidget(model, c, all);
            }
        } else {
            Iterator it = ts.listHomeResources();
            while (it.hasNext()) {
                RDFResource resource = (RDFResource)it.next();
                if (!(resource instanceof RDFSNamedClass)) continue;
                RDFSNamedClass cls = (RDFSNamedClass)resource;
                this.createFormWidget(model, cls, all);
            }
        }
        return model;
    }

    private String getFormsFileURI(TripleStore ts) {
        return AbsoluteFormsGenerator.getFormsFileURI(ts, this.owlModel);
    }

    public static String getFormsFileURI(TripleStore ts, OWLModel owlModel) {
        String baseURI = ts.getName();
        if (ts == owlModel.getTripleStoreModel().getTopTripleStore()) {
            baseURI = owlModel.getDefaultOWLOntology().getURI();
        } else if (ts == owlModel.getTripleStoreModel().getTripleStore(0)) {
            return PROTEGE_SYSTEM_FORMS_URI;
        }
        if (baseURI.endsWith("#")) {
            baseURI = baseURI.substring(0, baseURI.length() - 1);
        }
        baseURI = String.valueOf(baseURI) + SUFFIX;
        return baseURI;
    }

    public void generateFiles(String option) throws Exception {
        Iterator it = this.owlModel.getTripleStoreModel().listUserTripleStores();
        while (it.hasNext()) {
            TripleStore ts = (TripleStore)it.next();
            String formsFileName = this.getFormsFileURI(ts);
            URI ontologyFileURI = new URI(ts.getName());
            URI formsFileURI = new URI(formsFileName);
            Repository rep = this.owlModel.getRepositoryManager().getRepository(ontologyFileURI);
            if (rep != null) {
                if (!rep.isWritable(ontologyFileURI)) continue;
                System.out.println("Saving .forms model " + formsFileURI + " to " + rep.getOntologyLocationDescription(formsFileURI));
                OutputStream os = rep.getOutputStream(formsFileURI);
                Model model = this.createModel(ts, ALL.equals(option));
                String language = "RDF/XML-ABBREV";
                PrintStream ps = new PrintStream(os);
                String namespace = model.getNsPrefixURI("");
                RDFWriter writer = model.getWriter(language);
                Jena.prepareWriter(writer, language, namespace);
                writer.write(model, (OutputStream)ps, namespace);
                os.close();
                continue;
            }
            if (ts != this.owlModel.getTripleStoreModel().getTopTripleStore() || !(this.owlModel instanceof JenaOWLModel)) continue;
            String path = String.valueOf(((JenaOWLModel)this.owlModel).getOWLFilePath()) + SUFFIX;
            File file = new File(path);
            System.out.println("Saving .forms model " + formsFileURI + " to " + file);
            FileOutputStream os = new FileOutputStream(file);
            Model model = this.createModel(ts, ALL.equals(option));
            String language = "RDF/XML-ABBREV";
            PrintStream ps = new PrintStream(os);
            String namespace = model.getNsPrefixURI("");
            RDFWriter writer = model.getWriter(language);
            Jena.prepareWriter(writer, language, namespace);
            writer.write(model, (OutputStream)ps, namespace);
            ((OutputStream)os).close();
        }
    }

    private void saveSystemForms(String option) throws IOException {
        File file = new File(FILE_NAME);
        System.out.println("Saving system forms model to " + file);
        FileOutputStream os = new FileOutputStream(file);
        TripleStore ts = this.owlModel.getTripleStoreModel().getTripleStore(0);
        Model model = this.createModel(ts, ALL.equals(option));
        String language = "RDF/XML-ABBREV";
        PrintStream ps = new PrintStream(os);
        String namespace = "http://www.owl-ontologies.com/forms/protege-system.forms#";
        RDFWriter writer = model.getWriter(language);
        Jena.prepareWriter(writer, language, namespace);
        writer.write(model, (OutputStream)ps, namespace);
        ((OutputStream)os).close();
    }
}

