/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.icons;

import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class OverlayIcon
implements Icon {
    private Image baseImage;
    private int baseX;
    private int baseY;
    private int height;
    private Image topImage;
    private int topX;
    private int topY;
    private int width;

    public OverlayIcon(String baseIconName, int baseX, int baseY, String topIconName, int topX, int topY) {
        this(baseIconName, baseX, baseY, topIconName, topX, topY, OWLIcons.class);
    }

    public OverlayIcon(String baseIconName, int baseX, int baseY, String topIconName, int topX, int topY, Class clazz) {
        this(Toolkit.getDefaultToolkit().getImage(OWLIcons.getImageURL(clazz, baseIconName)), baseX, baseY, Toolkit.getDefaultToolkit().getImage(OWLIcons.getImageURL(OWLIcons.class, topIconName)), topX, topY);
    }

    public OverlayIcon(Image baseImage, int baseX, int baseY, Image topImage, int topX, int topY) {
        this(baseImage, baseX, baseY, topImage, topX, topY, 15, 15);
    }

    public OverlayIcon(Image baseImage, int baseX, int baseY, Image topImage, int topX, int topY, int width, int height) {
        this.baseImage = baseImage;
        this.baseX = baseX;
        this.baseY = baseY;
        this.topImage = topImage;
        this.topX = topX;
        this.topY = topY;
        this.width = width;
        this.height = height;
    }

    public int getIconHeight() {
        return this.height;
    }

    public int getIconWidth() {
        return this.width;
    }

    public Icon getGrayedIcon() {
        Image grayBaseImage = GrayFilter.createDisabledImage(this.baseImage);
        Image grayTopImage = GrayFilter.createDisabledImage(this.topImage);
        return new OverlayIcon(grayBaseImage, this.baseX, this.baseY, grayTopImage, this.topX, this.topY);
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (y > 0 && (this.baseX != 0 || this.baseY != 0 || this.topX != 0 || this.topY != 0)) {
            x = 0;
            y = 0;
        }
        new ImageIcon(this.baseImage).paintIcon(c, g, this.baseX + x, this.baseY + y);
        new ImageIcon(this.topImage).paintIcon(c, g, this.topX + x, this.topY + y);
    }
}

