/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.matrix;

import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.matrix.AbstractMatrixColumn;
import edu.stanford.smi.protegex.owl.ui.matrix.EditableMatrixColumn;
import edu.stanford.smi.protegex.owl.ui.matrix.SortableMatrixColumn;
import java.awt.Component;
import java.util.Comparator;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class NameMatrixColumn
extends AbstractMatrixColumn
implements EditableMatrixColumn,
SortableMatrixColumn {
    public NameMatrixColumn() {
        super("Name", 250);
    }

    public TableCellRenderer getCellRenderer() {
        return new FrameRenderer(){

            public void load(Object value) {
                if (value instanceof RDFResource) {
                    RDFResource instance = (RDFResource)value;
                    this.setGrayedText(false);
                    this.addIcon(ProtegeUI.getIcon(instance));
                    this.addText(instance.getLocalName());
                } else {
                    super.load(value);
                }
            }
        };
    }

    public Comparator getSortComparator() {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                RDFResource a = (RDFResource)o1;
                RDFResource b = (RDFResource)o2;
                int c = a.getLocalName().compareTo(b.getLocalName());
                if (c == 0) {
                    return a.getName().compareTo(b.getName());
                }
                return c;
            }
        };
    }

    public TableCellEditor getTableCellEditor() {
        JTextField textField = new JTextField();
        return new DefaultCellEditor(textField){

            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                RDFResource instance = (RDFResource)value;
                return super.getTableCellEditorComponent(table, instance.getLocalName(), isSelected, row, column);
            }
        };
    }

    public boolean isCellEditable(RDFResource instance) {
        return true;
    }

    public void setValueAt(RDFResource instance, Object value) {
        String oldName = instance.getLocalName();
        if (!oldName.equals(value)) {
            String newName = instance.getNamespacePrefix();
            newName = newName == null ? (String)value : String.valueOf(newName) + ":" + value;
            RDFResource other = instance.getOWLModel().getRDFResource(newName);
            if (other != null && !other.equals(instance)) {
                ProtegeUI.getModalDialogFactory().showErrorMessageDialog(instance.getOWLModel(), "The name \"" + newName + "\" is already used", "Rename failed");
            } else if (instance.getOWLModel().isValidResourceName(newName, instance)) {
                instance.setName(newName);
            } else {
                ProtegeUI.getModalDialogFactory().showErrorMessageDialog(instance.getOWLModel(), "\"" + newName + "\" is not a valid name\nfor " + instance.getBrowserText(), "Rename failed");
            }
        }
    }
}

