/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.matrix.cls;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.matrix.MatrixColumn;
import edu.stanford.smi.protegex.owl.ui.matrix.MatrixFilter;
import edu.stanford.smi.protegex.owl.ui.matrix.MatrixPanel;
import edu.stanford.smi.protegex.owl.ui.matrix.MatrixTableModel;
import edu.stanford.smi.protegex.owl.ui.matrix.cls.ClassMatrixTableModel;
import edu.stanford.smi.protegex.owl.ui.matrix.cls.ExistentialMatrixColumn;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceSelectionAction;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ClassMatrixPanel
extends MatrixPanel {
    private ResourceSelectionAction addExistentialAction = new ResourceSelectionAction("Add someValuesFrom column...", OWLIcons.getAddIcon("OWLSomeValuesFrom")){

        public void resourceSelected(RDFResource resource) {
            RDFProperty property = (RDFProperty)resource;
            ExistentialMatrixColumn col = new ExistentialMatrixColumn(property);
            ClassMatrixPanel.this.getTable().addColumn(col);
        }

        public RDFResource pickResource() {
            return ProtegeUI.getSelectionDialogFactory().selectResourceFromCollection(ClassMatrixPanel.this, ClassMatrixPanel.this.getOWLModel(), this.getSelectableResources(), "Select a property");
        }

        public Collection getSelectableResources() {
            RDFSNamedClass aClass = (RDFSNamedClass)ClassMatrixPanel.this.getTable().getSelectedInstance();
            Collection results = ClassMatrixPanel.getPotentialProperties(aClass);
            int count = ClassMatrixPanel.this.getTableModel().getColumnCount();
            int i = 0;
            while (i < count) {
                MatrixColumn col = ClassMatrixPanel.this.getTableModel().getMatrixColumn(i);
                if (col instanceof ExistentialMatrixColumn) {
                    results.remove(((ExistentialMatrixColumn)col).getProperty());
                }
                ++i;
            }
            return results;
        }
    };

    public ClassMatrixPanel(OWLModel owlModel, MatrixFilter filter) {
        this(owlModel, filter, new ClassMatrixTableModel(owlModel, filter));
    }

    public ClassMatrixPanel(OWLModel owlModel, MatrixFilter filter, MatrixTableModel tableModel) {
        super(owlModel, filter, tableModel);
        this.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ClassMatrixPanel.this.updateActions();
            }
        });
        this.addButton(this.addExistentialAction);
        this.updateActions();
    }

    static Collection getPotentialProperties(RDFSNamedClass aClass) {
        ArrayList<RDFProperty> results = new ArrayList<RDFProperty>();
        for (RDFProperty property : aClass.getUnionDomainProperties(true)) {
            if (!(property instanceof OWLObjectProperty) || ((OWLObjectProperty)property).isAnnotationProperty()) continue;
            results.add(property);
        }
        return results;
    }

    private void updateActions() {
        RDFSNamedClass aClass = (RDFSNamedClass)this.getTable().getSelectedInstance();
        boolean enabled = aClass instanceof OWLNamedClass;
        this.addExistentialAction.setEnabled(enabled);
    }
}

