/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.matrix.cls;

import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.matrix.DependentMatrixFilter;
import java.util.ArrayList;
import java.util.Collection;

public class SubclassesMatrixFilter
implements DependentMatrixFilter {
    private RDFSNamedClass parentClass;

    public SubclassesMatrixFilter(RDFSNamedClass parentClass) {
        this.parentClass = parentClass;
    }

    public Collection getInitialValues() {
        ArrayList results = new ArrayList();
        for (Object next : this.parentClass.getSubclasses(true)) {
            if (!(next instanceof RDFSNamedClass)) continue;
            results.add(next);
        }
        results.remove(this.parentClass);
        return results;
    }

    public String getName() {
        return "Subclasses of " + this.parentClass.getBrowserText();
    }

    public boolean isDependentOn(RDFResource instance) {
        return this.parentClass.equals(instance);
    }

    public boolean isSuitable(RDFResource instance) {
        return instance instanceof RDFSNamedClass && instance.isVisible() && (instance.isEditable() || instance.isIncluded()) && ((RDFSNamedClass)instance).isSubclassOf(this.parentClass);
    }
}

