/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.metadatatab;

import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protegex.owl.ui.metadatatab.OntologyURIDefaultSettingsPanel;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Calendar;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class OntologyURIPanel
extends JPanel {
    public static final String URI_BASE_PROPERTY = "OntURIBase";
    public static final String URI_BASE_APPEND_YEAR_PROPERTY = "OntURIBaseAppendYear";
    public static final String URI_BASE_APPEND_MONTH_PROPERTY = "OntURIBaseAppendMonth";
    public static final String URI_BASE_APPEND_DAY_PROPERTY = "OntURIBaseAppendDay";
    public static final String DEFAULT_BASE = "http://www.owl-ontologies.com";
    private JTextField textField;
    private ArrayList changeListeners = new ArrayList();
    private static final String HELP_TEXT = "<p>Please specify a URI for this ontology.</p>This URI will be used by other ontologies that wish to import this ontology.<p>In general, it is recommended that a URI which corresponds to the location of the ontology on the web should be used.  The URI should therefore resemble a HTTP URL, for example http://www.mydomain.com/myontology</p>";

    public OntologyURIPanel(boolean showHelp, boolean showDefaultSettingsButton) {
        this.createUI(showHelp, showDefaultSettingsButton);
    }

    public void addChangeListener(ChangeListener lsnr) {
        this.changeListeners.add(lsnr);
    }

    public void removeChangeListener(ChangeListener lsnr) {
        this.changeListeners.remove(lsnr);
    }

    private void setDefautOntologyURIBase() {
        String defaultBase = ApplicationProperties.getString((String)URI_BASE_PROPERTY);
        if (defaultBase == null) {
            defaultBase = DEFAULT_BASE;
            ApplicationProperties.setString((String)URI_BASE_PROPERTY, (String)DEFAULT_BASE);
        }
        if (defaultBase != null) {
            defaultBase = OntologyURIPanel.getOntologyURIBase(defaultBase, ApplicationProperties.getBooleanProperty((String)URI_BASE_APPEND_YEAR_PROPERTY, (boolean)false), ApplicationProperties.getBooleanProperty((String)URI_BASE_APPEND_MONTH_PROPERTY, (boolean)false), ApplicationProperties.getBooleanProperty((String)URI_BASE_APPEND_DAY_PROPERTY, (boolean)false));
            String fileName = "Ontology";
            fileName = String.valueOf(fileName) + System.currentTimeMillis() / 1000L;
            fileName = String.valueOf(fileName) + ".owl";
            this.textField.setText(String.valueOf(defaultBase) + fileName);
        }
    }

    private void fireChangeEvent() {
        for (ChangeListener lsnr : new ArrayList(this.changeListeners)) {
            lsnr.stateChanged(new ChangeEvent(this));
        }
    }

    public static String getOntologyURIBase(String defaultBase, boolean appendYear, boolean appendMonth, boolean appendDay) {
        if (defaultBase != null && defaultBase.trim().length() > 0) {
            if (!defaultBase.endsWith("/")) {
                defaultBase = String.valueOf(defaultBase) + "/";
            }
            if (appendYear) {
                int year = Calendar.getInstance().get(1);
                defaultBase = String.valueOf(defaultBase) + year + "/";
                if (appendMonth) {
                    int month = Calendar.getInstance().get(2) + 1;
                    defaultBase = String.valueOf(defaultBase) + month + "/";
                    if (appendDay) {
                        int day = Calendar.getInstance().get(5);
                        defaultBase = String.valueOf(defaultBase) + day + "/";
                    }
                }
            }
        }
        return defaultBase;
    }

    public URI getOntologyURI() {
        if (this.validateName()) {
            try {
                return new URI(this.textField.getText());
            }
            catch (URISyntaxException e) {
                return null;
            }
        }
        return null;
    }

    private void createUI(boolean showHelp, boolean showDefaultSettingsButton) {
        this.setLayout(new BorderLayout(7, 7));
        this.textField = new JTextField();
        this.setDefautOntologyURIBase();
        this.textField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                OntologyURIPanel.this.validateName();
                OntologyURIPanel.this.fireChangeEvent();
            }

            public void removeUpdate(DocumentEvent e) {
                OntologyURIPanel.this.validateName();
                OntologyURIPanel.this.fireChangeEvent();
            }

            public void changedUpdate(DocumentEvent e) {
            }
        });
        JPanel holder = new JPanel(new BorderLayout(3, 3));
        holder.add((Component)this.textField, "North");
        if (showDefaultSettingsButton) {
            JPanel buttonHolder = new JPanel(new FlowLayout(2));
            buttonHolder.add(new JButton(new AbstractAction("Default settings..."){

                public void actionPerformed(ActionEvent e) {
                    OntologyURIDefaultSettingsPanel.showDialog(OntologyURIPanel.this);
                    OntologyURIPanel.this.setDefautOntologyURIBase();
                }
            }));
            holder.add((Component)buttonHolder, "South");
        }
        LabeledComponent lc = new LabeledComponent("Ontology URI (Usually a URL starting with http://)", (Component)holder);
        this.add((Component)lc, "North");
        if (showHelp) {
            this.add((Component)OWLUI.createHelpPanel(HELP_TEXT, null), "South");
        }
        this.validateName();
    }

    private boolean validateName() {
        block3: {
            try {
                URI uri = new URI(this.textField.getText().trim());
                if (!uri.isAbsolute()) break block3;
                this.textField.setForeground(Color.BLACK);
                return true;
            }
            catch (URISyntaxException e) {
                this.textField.setForeground(Color.RED);
                return false;
            }
        }
        this.textField.setForeground(Color.RED);
        return false;
    }
}

