/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.metadatatab.imports.wizard;

import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.WizardPage;
import edu.stanford.smi.protegex.owl.ui.metadatatab.imports.wizard.AbstractImportStartWizardPage;
import edu.stanford.smi.protegex.owl.ui.metadatatab.imports.wizard.ImportVerificationPage;
import edu.stanford.smi.protegex.owl.ui.metadatatab.imports.wizard.ImportWizard;
import edu.stanford.smi.protegex.owl.ui.metadatatab.imports.wizard.URLImportEntry;
import java.awt.Component;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class URLImportPage
extends AbstractImportStartWizardPage {
    private JTextField urlField;
    private static final String HELP_TEXT = "<p>Please specify the URL that points to the document containing the ontology to be imported. The URL can be specified by typing it into the above text field, or it could be copied and pasted from a web browser for example.</p>";

    public URLImportPage(ImportWizard wizard) {
        super("URL Import Page", wizard);
        this.createUI();
    }

    private void createUI() {
        this.setHelpText("Importing an ontology from the web", HELP_TEXT);
        this.urlField = new JTextField();
        this.urlField.setColumns(40);
        this.urlField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                URLImportPage.this.setPageComplete(URLImportPage.this.validateData());
            }

            public void removeUpdate(DocumentEvent e) {
                URLImportPage.this.setPageComplete(URLImportPage.this.validateData());
            }

            public void changedUpdate(DocumentEvent e) {
                URLImportPage.this.setPageComplete(URLImportPage.this.validateData());
            }
        });
        LabeledComponent lc = new LabeledComponent("Ontology URL (http://...)", (Component)this.urlField);
        this.getContentComponent().add((Component)lc, "North");
        this.setPageComplete(this.validateData());
    }

    public void nextPressed() {
        try {
            URL url = new URL(this.urlField.getText().trim());
            this.getImportWizard().getImportData().addImportEntry(new URLImportEntry(url));
        }
        catch (MalformedURLException e) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", e);
        }
    }

    private boolean validateData() {
        if (this.urlField.getText().trim().length() == 0) {
            return false;
        }
        try {
            URL url = new URL(this.urlField.getText().trim());
            return url.getHost().length() > 0 && url.getProtocol() != null && url.getProtocol().equals("http");
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public WizardPage getNextPage() {
        return new ImportVerificationPage(this.getImportWizard());
    }
}

