/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.navigation;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.ui.ProjectView;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectionEvent;
import edu.stanford.smi.protege.util.SelectionListener;
import edu.stanford.smi.protege.widget.TabWidget;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.navigation.NavigationHistorySelectable;
import edu.stanford.smi.protegex.owl.ui.navigation.NavigationHistoryTabWidget;
import edu.stanford.smi.protegex.owl.ui.navigation.ProgrammaticSelectionEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.JComponent;

public class TabNavigationHistorySelectable
implements Disposable,
NavigationHistorySelectable,
SelectionListener {
    private Collection listeners = new HashSet();
    private boolean programmaticNavigation = false;
    private Project project;
    private Collection tabs = new ArrayList();

    public TabNavigationHistorySelectable(OWLModel owlModel) {
        this.project = owlModel.getProject();
        ProjectView view = ProtegeUI.getProjectView(this.project);
        view.getTabbedPane().addContainerListener(new ContainerListener(){

            public void componentAdded(ContainerEvent e) {
                TabNavigationHistorySelectable.this.reinit();
            }

            public void componentRemoved(ContainerEvent e) {
                TabNavigationHistorySelectable.this.reinit();
            }
        });
        this.reinit();
    }

    public void addSelectionListener(SelectionListener listener) {
        this.listeners.add(listener);
    }

    public void clearSelection() {
    }

    public void dispose() {
        this.removeListener();
    }

    public Collection getSelection() {
        ProjectView view = ProtegeUI.getProjectView(this.project);
        TabWidget tabWidget = view.getSelectedTab();
        if (tabWidget instanceof NavigationHistoryTabWidget) {
            NavigationHistoryTabWidget tab = (NavigationHistoryTabWidget)tabWidget;
            Selectable sel = tab.getNestedSelectable();
            return sel.getSelection();
        }
        return Collections.EMPTY_LIST;
    }

    public void navigateToResource(RDFResource resource) {
        ProjectView view = ProtegeUI.getProjectView(this.project);
        ArrayList<TabWidget> list = new ArrayList<TabWidget>();
        list.add(view.getSelectedTab());
        list.addAll(this.tabs);
        try {
            this.programmaticNavigation = true;
            for (Object e : list) {
                if (!(e instanceof NavigationHistoryTabWidget) || !((NavigationHistoryTabWidget)e).displayHostResource(resource)) continue;
                view.setSelectedTab((TabWidget)e);
                ((JComponent)e).requestFocusInWindow();
                return;
            }
        }
        finally {
            this.programmaticNavigation = false;
        }
    }

    public void notifySelectionListeners() {
        for (SelectionListener listener : this.listeners) {
            ProgrammaticSelectionEvent event = this.programmaticNavigation ? new ProgrammaticSelectionEvent(this) : new SelectionEvent((Selectable)this, 1);
            listener.selectionChanged((SelectionEvent)event);
        }
    }

    public void reinit() {
        this.removeListener();
        ProjectView view = ProtegeUI.getProjectView(this.project);
        for (Object tab : view.getTabs()) {
            if (!(tab instanceof NavigationHistoryTabWidget)) continue;
            NavigationHistoryTabWidget widget = (NavigationHistoryTabWidget)tab;
            this.tabs.add(tab);
            Selectable selectable = widget.getNestedSelectable();
            selectable.addSelectionListener((SelectionListener)this);
        }
    }

    private void removeListener() {
        for (NavigationHistoryTabWidget tab : this.tabs) {
            Selectable selectable = tab.getNestedSelectable();
            selectable.removeSelectionListener((SelectionListener)this);
        }
        this.tabs.clear();
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.listeners.remove(listener);
    }

    public void selectionChanged(SelectionEvent event) {
        this.notifySelectionListeners();
    }
}

