/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.repository;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.repository.RepositoryManager;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.repository.AbstractRepositoriesPanel;
import edu.stanford.smi.protegex.owl.ui.repository.GlobalRepositoriesPanel;
import edu.stanford.smi.protegex.owl.ui.repository.ProjectRepositoriesPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class RepositoryManagerPanel
extends JPanel {
    private OWLModel model;
    private RepositoryManager repositoryManager;
    private AbstractRepositoriesPanel globalRepositoriesPanel;
    private AbstractRepositoriesPanel projectRepositoriesPanel;
    private ArrayList cachedRepositories;

    public RepositoryManagerPanel(OWLModel model) {
        this.model = model;
        this.repositoryManager = model.getRepositoryManager();
        this.cachedRepositories = new ArrayList();
        Iterator it = this.repositoryManager.getAllRepositories().iterator();
        while (it.hasNext()) {
            this.cachedRepositories.add(it.next());
        }
        this.createUI();
    }

    public Dimension getPreferredSize() {
        return new Dimension(700, 500);
    }

    private void createUI() {
        this.setLayout(new BorderLayout());
        JTabbedPane tabbedPane = new JTabbedPane();
        this.projectRepositoriesPanel = new ProjectRepositoriesPanel(this.model, this.repositoryManager);
        tabbedPane.add(this.projectRepositoriesPanel.getRepositoriesTitle(), this.projectRepositoriesPanel);
        this.globalRepositoriesPanel = new GlobalRepositoriesPanel(this.model, this.repositoryManager);
        tabbedPane.add(this.globalRepositoriesPanel.getRepositoriesTitle(), this.globalRepositoriesPanel);
        this.add(tabbedPane);
    }

    private boolean repositoriesChanged() {
        List repositories = this.repositoryManager.getAllRepositories();
        if (repositories.size() != this.cachedRepositories.size()) {
            return true;
        }
        Iterator cachedRepIt = this.cachedRepositories.iterator();
        Iterator it = repositories.iterator();
        while (it.hasNext()) {
            if (it.next().equals(cachedRepIt.next())) continue;
            return true;
        }
        return false;
    }

    public static void showDialog(Component parent, OWLModel owlModel) {
        Object[] options;
        int val;
        RepositoryManagerPanel pan = new RepositoryManagerPanel(owlModel);
        int ret = ProtegeUI.getModalDialogFactory().showDialog(parent, pan, "Repository Manager", 14);
        if (owlModel.getAllImports().size() > 0 && pan.repositoriesChanged() && (val = JOptionPane.showOptionDialog(pan, "<html><body>The order of repositories has changed.<br>The system needs to reload the current project. Press 'reload' to save and reload, or cancel to do a manual reload.</body></html>", "Save and reload required", 2, 2, null, options = new String[]{"Reload", "Cancel"}, options[0])) == 0) {
            OWLUtil.saveAndReloadProject();
        }
    }
}

