/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.repository;

import edu.stanford.smi.protegex.owl.jena.parser.UnresolvedImportHandler;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.ui.repository.wizard.RepositoryWizard;
import java.awt.HeadlessException;
import java.net.URI;
import java.util.ArrayList;
import javax.swing.JOptionPane;

public class UnresolvedImportUIHandler
implements UnresolvedImportHandler {
    public static final String ADD_OPTION = "Add Repository";
    public static final String CANCEL_OPTION = "Cancel";
    public static final ArrayList OPTIONS = new ArrayList();

    public UnresolvedImportUIHandler() {
        OPTIONS.add(ADD_OPTION);
        OPTIONS.add(CANCEL_OPTION);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Repository handleUnresolvableImport(OWLModel model, TripleStore tripleStore, URI ontologyName) {
        try {
            Repository rep = null;
            while (true) {
                if (rep != null) {
                    return null;
                }
                if (this.showMessage(ontologyName) == OPTIONS.indexOf(CANCEL_OPTION)) {
                    return null;
                }
                RepositoryWizard wizard = new RepositoryWizard(null, model);
                if (wizard.execute() == 2) {
                    return null;
                }
                rep = wizard.getRepository();
                if (rep != null) {
                    if (rep.contains(ontologyName)) {
                        return rep;
                    }
                    rep = null;
                }
                wizard.dispose();
            }
        }
        catch (HeadlessException he) {
            return null;
        }
    }

    private int showMessage(URI ontologyName) {
        return JOptionPane.showOptionDialog(null, "The system cannot find the ontology:\n" + ontologyName + "\n\n" + "Select '" + ADD_OPTION + "' to add a repository that contains\n" + "this ontology, or select '" + CANCEL_OPTION + "' to stop " + "loading and exit.", "Unresolved import", 2, 0, null, OPTIONS.toArray(), ADD_OPTION);
    }
}

