/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.widget;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.impl.XMLSchemaDatatypes;
import edu.stanford.smi.protegex.owl.ui.widget.OWLDateWidget;
import edu.stanford.smi.protegex.owl.ui.widget.OWLWidgetMapper;
import edu.stanford.smi.protegex.owl.ui.widget.TimePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Date;
import javax.swing.JPanel;

public class OWLDateTimeWidget
extends OWLDateWidget
implements TimePanel.Listener {
    private TimePanel timePanel;

    public OWLDateTimeWidget() {
        this.setPreferredColumns(3);
        this.timePanel = new TimePanel(this);
    }

    protected RDFSLiteral createPropertyValue(Date date) {
        String str = XMLSchemaDatatypes.getDateString(date);
        RDFSDatatype datatype = this.getOWLModel().getRDFSDatatypeByURI(XSDDatatype.XSDdateTime.getURI());
        str = String.valueOf(str) + "T" + this.timePanel.getTime();
        return this.getOWLModel().createRDFSLiteral(str, datatype);
    }

    protected void deleteValue() {
        super.deleteValue();
        this.timePanel.clear();
    }

    protected Component getCenterComponent() {
        Component dateComponent = super.getCenterComponent();
        JPanel panel = new JPanel(new BorderLayout(4, 0));
        panel.add("Center", dateComponent);
        panel.add("East", this.timePanel);
        return panel;
    }

    protected void setValue(String s) {
        super.setValue(s);
        if (s != null) {
            int index = s.indexOf("T");
            if (index >= 0) {
                s = s.substring(index + 1);
                this.timePanel.setTime(s);
            } else {
                this.timePanel.clear();
            }
        } else {
            this.timePanel.clear();
        }
    }

    public void timeChanged(TimePanel timePanel) {
        this.updateValues();
    }

    protected void updateComponents() {
        super.updateComponents();
        RDFResource resource = this.getEditedResource();
        RDFProperty property = this.getRDFProperty();
        this.timePanel.setEnabled(resource != null && property != null && resource.isEditable());
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        return OWLWidgetMapper.isSuitable(OWLDateTimeWidget.class, cls, slot);
    }
}

