/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.widget;

import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import java.util.Collection;

public class OWLWidgetUtil {
    public static boolean isDatatypeProperty(RDFSNamedClass cls, RDFProperty property) {
        RDFResource allValuesFrom;
        if (property instanceof OWLObjectProperty) {
            return false;
        }
        if (property instanceof OWLDatatypeProperty) {
            return true;
        }
        if (cls instanceof OWLNamedClass && (allValuesFrom = ((OWLNamedClass)cls).getAllValuesFrom(property)) instanceof RDFSDatatype) {
            return true;
        }
        return property.getRange() instanceof RDFSDatatype;
    }

    public static boolean isDatatypeProperty(RDFSDatatype datatype, RDFSNamedClass cls, RDFProperty property) {
        OWLNamedClass namedClass;
        if (cls instanceof OWLNamedClass && datatype.equals((namedClass = (OWLNamedClass)cls).getAllValuesFrom(property))) {
            return true;
        }
        return datatype.equals(property.getRange());
    }

    public static boolean isFunctionalProperty(RDFSNamedClass cls, RDFProperty property) {
        if (cls instanceof OWLNamedClass) {
            OWLNamedClass namedClass = (OWLNamedClass)cls;
            int maxCardinality = namedClass.getMaxCardinality(property);
            return maxCardinality == 0 || maxCardinality == 1;
        }
        return property.isFunctional();
    }

    public static boolean isRangelessDatatypeProperty(RDFSNamedClass cls, RDFProperty property) {
        if (property instanceof OWLObjectProperty) {
            return false;
        }
        if (cls instanceof OWLNamedClass) {
            OWLNamedClass namedClass = (OWLNamedClass)cls;
            RDFResource allValuesFrom = namedClass.getAllValuesFrom(property);
            return allValuesFrom == null;
        }
        return property.getRange() == null;
    }

    public static boolean isRangelessObjectProperty(RDFSNamedClass cls, RDFProperty property) {
        if (property instanceof OWLDatatypeProperty) {
            return false;
        }
        if (cls instanceof OWLNamedClass) {
            OWLNamedClass namedClass = (OWLNamedClass)cls;
            RDFResource allValuesFrom = namedClass.getAllValuesFrom(property);
            return allValuesFrom == null;
        }
        return property.getRange() == null && property instanceof OWLObjectProperty;
    }

    public static boolean isRestrictedProperty(RDFSNamedClass namedClass, RDFProperty property) {
        if (namedClass instanceof OWLNamedClass) {
            OWLNamedClass namedCls = (OWLNamedClass)namedClass;
            Collection restrictions = namedCls.getRestrictions(property, true);
            if (!restrictions.isEmpty()) {
                return true;
            }
            for (RDFProperty superproperty : property.getSuperproperties(false)) {
                if (!OWLWidgetUtil.isRestrictedProperty(namedClass, superproperty)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isSingleDatatypeProperty(RDFSDatatype datatype, RDFSNamedClass cls, RDFProperty property) {
        return OWLWidgetUtil.isDatatypeProperty(datatype, cls, property) && OWLWidgetUtil.isFunctionalProperty(cls, property);
    }
}

