/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.writer.rdfxml.rdfwriter;

import edu.stanford.smi.protegex.owl.model.OWLAllDifferent;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.writer.rdfxml.rdfwriter.RDFXMLContentWriter;
import edu.stanford.smi.protegex.owl.writer.rdfxml.renderer.RDFAxiomRenderer;
import edu.stanford.smi.protegex.owl.writer.rdfxml.renderer.RDFResourceRenderer;
import edu.stanford.smi.protegex.owl.writer.xml.XMLWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;

public class OWLModelContentWriter
implements RDFXMLContentWriter {
    private OWLModel model;
    private TripleStore tripleStore;

    public OWLModelContentWriter(OWLModel model, TripleStore tripleStore) {
        this.model = model;
        this.tripleStore = tripleStore;
    }

    public void writeContent(XMLWriter writer) throws IOException {
        HashSet<RDFResource> renderedResources = new HashSet<RDFResource>();
        for (OWLOntology ont : this.model.getOWLOntologies()) {
            if (!ont.getOWLModel().getTripleStoreModel().getHomeTripleStore(ont).equals(this.tripleStore)) continue;
            RDFResourceRenderer renderer = new RDFResourceRenderer(ont, this.tripleStore, writer);
            renderer.write();
            renderedResources.add(ont);
        }
        for (OWLAllDifferent curAllDifferent : this.model.getOWLAllDifferents()) {
            if (!this.model.getTripleStoreModel().getHomeTripleStore(curAllDifferent).equals(this.tripleStore)) continue;
            RDFResourceRenderer ren = new RDFResourceRenderer(curAllDifferent, this.tripleStore, writer);
            ren.write();
            renderedResources.add(curAllDifferent);
        }
        Iterator it = this.tripleStore.listHomeResources();
        while (it.hasNext()) {
            RDFResource curRes = (RDFResource)it.next();
            if (curRes.isSystem() || curRes.isAnonymous()) continue;
            RDFAxiomRenderer axiomRenderer = new RDFAxiomRenderer(curRes, this.tripleStore, writer);
            axiomRenderer.write();
            renderedResources.add(curRes);
        }
        for (RDFProperty curProp : this.model.getRDFProperties()) {
            Iterator subjIt = this.tripleStore.listSubjects(curProp);
            while (subjIt.hasNext()) {
                RDFResource curSubj;
                Object subj = subjIt.next();
                if (!(subj instanceof RDFResource) || (curSubj = (RDFResource)subj).isAnonymous() || curSubj.isSystem() || renderedResources.contains(curSubj)) continue;
                RDFAxiomRenderer axiomRenderer = new RDFAxiomRenderer(curSubj, this.tripleStore, writer);
                axiomRenderer.write();
                renderedResources.add(curSubj);
            }
        }
    }
}

