/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owlx.examples;

import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class FormInStandAloneApplicationExample {
    public static void main(String[] args) {
        JFileChooser fileChooser = ComponentFactory.createFileChooser((String)"Project Files", (String)".pprj");
        if (fileChooser.showOpenDialog(null) == 0) {
            File projectFile = fileChooser.getSelectedFile();
            ArrayList errors = new ArrayList();
            Project project = Project.loadProjectFromFile((String)projectFile.getAbsolutePath(), errors);
            if (!errors.isEmpty()) {
                JOptionPane.showMessageDialog(null, "Could not load " + projectFile, "Error", 0);
                return;
            }
            KnowledgeBase kb = project.getKnowledgeBase();
            if (!(kb instanceof OWLModel)) {
                JOptionPane.showMessageDialog(null, "This is not an OWL project.", "Error", 0);
                return;
            }
            OWLModel owlModel = (OWLModel)kb;
            RDFResource resource = ProtegeUI.getSelectionDialogFactory().selectResourceByType(null, owlModel, Collections.singleton(owlModel.getOWLThingClass()));
            if (resource != null) {
                FormInStandAloneApplicationExample.editResourceInForm(resource);
            } else {
                System.exit(0);
            }
        } else {
            System.exit(0);
        }
    }

    private static void handleClose(OWLModel owlModel) {
        if (JOptionPane.showConfirmDialog(null, "Do you want to save your changes?", "Confirm Save", 0) == 0) {
            ArrayList errors = new ArrayList();
            owlModel.getProject().save(errors);
            if (!errors.isEmpty()) {
                ProtegeUI.getModalDialogFactory().showErrorMessageDialog(owlModel, "Could not save project.");
            }
        }
        System.exit(0);
    }

    private static void editResourceInForm(final RDFResource resource) {
        Project project = resource.getProject();
        JFrame frame = project.show((Instance)resource);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
                FormInStandAloneApplicationExample.handleClose(resource.getOWLModel());
            }
        });
    }
}

