/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.javacode;

import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protegex.owl.javacode.EditableJavaCodeGeneratorOptions;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class JavaCodeGeneratorPanel
extends JPanel {
    private JCheckBox abstractCheckBox;
    private JTextField factoryClassNameTextField;
    private JFileChooser fileChooser = new JFileChooser(".");
    private EditableJavaCodeGeneratorOptions options;
    private JTextField packageTextField;
    private JTextField rootFolderTextField;
    private JCheckBox setCheckBox;

    public JavaCodeGeneratorPanel(EditableJavaCodeGeneratorOptions options) {
        this.options = options;
        this.packageTextField = new JTextField();
        if (options.getPackage() != null) {
            this.packageTextField.setText(options.getPackage());
        }
        this.rootFolderTextField = new JTextField();
        if (options.getOutputFolder() != null) {
            this.rootFolderTextField.setText(options.getOutputFolder().getAbsolutePath());
        }
        this.fileChooser.setDialogTitle("Select output folder");
        this.fileChooser.setFileSelectionMode(1);
        this.factoryClassNameTextField = new JTextField();
        if (options.getFactoryClassName() != null) {
            this.factoryClassNameTextField.setText(options.getFactoryClassName());
        }
        this.abstractCheckBox = new JCheckBox("Create abstract base files (e.g., Person_)");
        this.abstractCheckBox.setSelected(options.getAbstractMode());
        this.setCheckBox = new JCheckBox("Return Set instead of Collection");
        this.setCheckBox.setSelected(options.getSetMode());
        this.setLayout(new BoxLayout(this, 1));
        LabeledComponent lc = new LabeledComponent("Root output folder", (Component)this.rootFolderTextField);
        lc.addHeaderButton((Action)new AbstractAction("Select folder...", Icons.getAddIcon()){

            public void actionPerformed(ActionEvent e) {
                JavaCodeGeneratorPanel.this.selectFolder();
            }
        });
        this.add((Component)lc);
        this.add(Box.createVerticalStrut(8));
        this.add((Component)new LabeledComponent("Java package", (Component)this.packageTextField));
        this.add(Box.createVerticalStrut(8));
        this.add((Component)new LabeledComponent("Factory class name", (Component)this.factoryClassNameTextField));
        this.add(Box.createVerticalStrut(8));
        this.add(this.createCheckBoxPanel(this.abstractCheckBox));
        this.add(Box.createVerticalStrut(8));
        this.add(this.createCheckBoxPanel(this.setCheckBox));
        this.add(Box.createVerticalStrut(8));
    }

    private JPanel createCheckBoxPanel(Component comp) {
        JPanel southPanel = new JPanel(new BorderLayout());
        southPanel.add("West", comp);
        southPanel.add("Center", new JPanel());
        southPanel.setPreferredSize(new Dimension(300, 24));
        return southPanel;
    }

    public void ok() {
        File newFile = null;
        String rootFolder = this.rootFolderTextField.getText().trim();
        if (rootFolder.length() > 0) {
            newFile = new File(rootFolder);
        }
        this.options.setOutputFolder(newFile);
        this.options.setAbstractMode(this.abstractCheckBox.isSelected());
        this.options.setSetMode(this.setCheckBox.isSelected());
        this.options.setFactoryClassName(this.factoryClassNameTextField.getText());
        String pack = this.packageTextField.getText().trim();
        this.options.setPackage(pack.length() > 0 ? pack : null);
    }

    private void selectFolder() {
        if (this.fileChooser.showDialog(this, "Select") == 0) {
            File file = this.fileChooser.getSelectedFile();
            this.rootFolderTextField.setText(file.toString());
        }
    }
}

