/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.ontology.AllValuesFromRestriction;
import com.hp.hpl.jena.ontology.AnnotationProperty;
import com.hp.hpl.jena.ontology.CardinalityRestriction;
import com.hp.hpl.jena.ontology.ComplementClass;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.EnumeratedClass;
import com.hp.hpl.jena.ontology.FunctionalProperty;
import com.hp.hpl.jena.ontology.HasValueRestriction;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.IntersectionClass;
import com.hp.hpl.jena.ontology.MaxCardinalityRestriction;
import com.hp.hpl.jena.ontology.MinCardinalityRestriction;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.ontology.Ontology;
import com.hp.hpl.jena.ontology.Restriction;
import com.hp.hpl.jena.ontology.SomeValuesFromRestriction;
import com.hp.hpl.jena.ontology.SymmetricProperty;
import com.hp.hpl.jena.ontology.TransitiveProperty;
import com.hp.hpl.jena.ontology.UnionClass;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.ResourceUtils;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Filter;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protegex.owl.jena.Jena;
import edu.stanford.smi.protegex.owl.model.NamespaceManager;
import edu.stanford.smi.protegex.owl.model.ProtegeNames;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JenaNormalizer {
    private static boolean logging = false;
    private static String LOGGING = String.valueOf(JenaNormalizer.class.getName()) + ".logging";
    private OntModel ontModel;
    private Model owlFullModel;

    public JenaNormalizer(OntModel ontModel, Model owlFullModel, NamespaceManager namespaceManager) {
        this.owlFullModel = owlFullModel;
        this.ontModel = ontModel;
        Jena.ensureOWLFullModelIsLastModel(ontModel, owlFullModel);
        JenaNormalizer.updateLoggingStatus();
        String defaultNamespace = namespaceManager.getDefaultNamespace();
        JenaNormalizer.standardizePrefixes(ontModel);
        this.alignPrefixes(ontModel, namespaceManager);
        this.createPrefixesForImports(ontModel, namespaceManager);
        this.mergeOntologies();
        this.ensureAnnotationPropertiesHaveRange();
        if (owlFullModel != null) {
            this.ensureDeprecatedClassesAreOntClasses(owlFullModel);
            this.ensureDeprecatedPropertiesAreOntProperties(owlFullModel);
            this.ensureFunctionalPropertiesAreOntProperties(owlFullModel);
            this.ensureSymmetricPropertiesAreOntProperties(owlFullModel);
            this.ensureTransitivePropertiesAreOntProperties(owlFullModel);
        }
        this.convertCyclicPropertyInheritance();
        this.assignNamesToAnonymousTopLevelClasses(ontModel, defaultNamespace);
        this.convertNamedClassExpressions();
        if (owlFullModel != null) {
            JenaNormalizer.assignRDFTypesToMetaclassInstances(ontModel, owlFullModel);
            this.ensureSuperclassesAreRDFSClasses(owlFullModel);
            this.ensureSuperPropertiesAreRDFProperties(owlFullModel);
        }
        this.removeRedundantDomains((Iterator)ontModel.listDatatypeProperties());
        this.removeRedundantDomains((Iterator)ontModel.listObjectProperties());
        this.convertMultipleDomainsIntoIntersection(ontModel);
        this.convertMultipleRangesIntoIntersection(ontModel);
    }

    private void createPrefixesForImports(OntModel ontModel, NamespaceManager nsm) {
        String def = ontModel.getNsPrefixURI("");
        ExtendedIterator it = ontModel.listOntologies();
        while (it.hasNext()) {
            Ontology ontology = (Ontology)it.next();
            ExtendedIterator iit = ontology.listImports();
            while (iit.hasNext()) {
                String pre;
                Resource o = (Resource)iit.next();
                String uri = o.getURI();
                if (!uri.endsWith("/") && !uri.endsWith("#")) {
                    uri = String.valueOf(uri) + "#";
                }
                if (def.equals(uri) || ontModel.getOntology(o.getURI()) == null || (pre = ontModel.getNsURIPrefix(uri)) != null && pre.length() != 0) continue;
                String prefix = this.createImportURI(ontModel);
                ontology.getModel().setNsPrefix(prefix, uri);
                nsm.setPrefix(uri, prefix);
            }
        }
    }

    private String createImportURI(OntModel ontModel) {
        String prefix = null;
        String prefixBase = "import";
        int i = 1;
        while (ontModel.getNsPrefixURI(prefix = String.valueOf(prefixBase) + i++) != null) {
        }
        return prefix;
    }

    private void alignPrefixes(OntModel ontModel, NamespaceManager nsm) {
        List graphs = ontModel.getSubGraphs();
        for (Graph graph : graphs) {
            Map map = graph.getPrefixMapping().getNsPrefixMap();
            for (String localPrefix : map.keySet()) {
                String uri;
                String globalPrefix;
                if (localPrefix.length() <= 0 || localPrefix.equals(globalPrefix = ontModel.getNsURIPrefix(uri = (String)map.get(localPrefix)))) continue;
                JenaNormalizer.log("Prefix mismatch " + localPrefix + " aligned to " + globalPrefix + " for namespace " + uri);
                graph.getPrefixMapping().removeNsPrefix(localPrefix);
                graph.getPrefixMapping().setNsPrefix(globalPrefix, uri);
                nsm.setPrefix(uri, globalPrefix);
                nsm.removePrefix(localPrefix);
            }
        }
    }

    private void ensureDeprecatedClassesAreOntClasses(Model owlFullModel) {
        for (Resource c : Jena.set((Iterator)this.ontModel.listSubjectsWithProperty(RDF.type, (RDFNode)OWL.DeprecatedClass))) {
            if (c.canAs(OntClass.class)) continue;
            this.ontModel.add(c, RDF.type, (RDFNode)RDFS.Class);
            JenaNormalizer.log("+ Made deprecated class " + c + " an RDFS class");
        }
    }

    private void ensureDeprecatedPropertiesAreOntProperties(Model owlFullModel) {
        for (Resource property : Jena.set((Iterator)this.ontModel.listSubjectsWithProperty(RDF.type, (RDFNode)OWL.DeprecatedProperty))) {
            if (property.canAs(OntProperty.class)) continue;
            this.ontModel.add(property, RDF.type, (RDFNode)RDF.Property);
            JenaNormalizer.log("+ Made deprecated property " + property + " an RDF property");
        }
    }

    private void ensureFunctionalPropertiesAreOntProperties(Model owlFullModel) {
        for (FunctionalProperty property : Jena.set((Iterator)this.ontModel.listFunctionalProperties())) {
            if (this.hasValidPropertyType((Property)property)) continue;
            this.ontModel.add((Resource)property, RDF.type, (RDFNode)RDF.Property);
            JenaNormalizer.log("+ Made functional property " + property + " an RDF property");
        }
    }

    private boolean hasValidPropertyType(Property property) {
        StmtIterator it = property.listProperties(RDF.type);
        while (it.hasNext()) {
            Statement s = it.nextStatement();
            Resource object = (Resource)s.getObject();
            if (!object.equals((Object)OWL.ObjectProperty) && !object.equals((Object)OWL.DatatypeProperty) && !object.equals((Object)RDF.Property) && object.getURI().startsWith("http://www.w3.org/2002/07/owl#")) continue;
            return true;
        }
        return false;
    }

    private void ensureSuperclassesAreRDFSClasses(Model owlFullModel) {
        NodeIterator it = this.ontModel.listObjectsOfProperty(RDFS.subClassOf);
        while (it.hasNext()) {
            RDFNode node = (RDFNode)it.next();
            if (Jena.canAsOntClass(node) || !node.canAs(Resource.class)) continue;
            owlFullModel.add((Resource)node.as(Resource.class), RDF.type, (RDFNode)RDFS.Class);
            JenaNormalizer.log("+ Made non-imported superclass " + node + " an " + RDFS.Class);
        }
    }

    private void ensureSuperPropertiesAreRDFProperties(Model owlFullModel) {
        NodeIterator it = this.ontModel.listObjectsOfProperty(RDFS.subPropertyOf);
        while (it.hasNext()) {
            RDFNode node = (RDFNode)it.next();
            if (node.canAs(OntProperty.class) || !node.canAs(Resource.class)) continue;
            owlFullModel.add((Resource)node.as(Resource.class), RDF.type, (RDFNode)RDF.Property);
            JenaNormalizer.log("+ Made non-imported superclass " + node + " an " + RDF.Property);
        }
    }

    private void ensureSymmetricPropertiesAreOntProperties(Model owlFullModel) {
        for (SymmetricProperty property : Jena.set((Iterator)this.ontModel.listSymmetricProperties())) {
            if (this.hasValidPropertyType((Property)property)) continue;
            this.ontModel.add((Resource)property, RDF.type, (RDFNode)OWL.ObjectProperty);
            JenaNormalizer.log("+ Made symmetric property " + property + " an object property");
        }
    }

    private void ensureTransitivePropertiesAreOntProperties(Model owlFullModel) {
        for (TransitiveProperty property : Jena.set((Iterator)this.ontModel.listTransitiveProperties())) {
            if (this.hasValidPropertyType((Property)property)) continue;
            this.ontModel.add((Resource)property, RDF.type, (RDFNode)OWL.ObjectProperty);
            JenaNormalizer.log("+ Made transitive property " + property + " an object property");
        }
    }

    private void assignNamesToAnonymousIndividuals(OntModel ontModel, String defaultNamespace) {
        String baseName = String.valueOf(defaultNamespace) + "@";
        int index = 1;
        Iterator it = Jena.cloneIt((Iterator)ontModel.listIndividuals());
        while (it.hasNext()) {
            String name;
            Resource type;
            String ns;
            Individual individual = (Individual)it.next();
            if (individual.getURI() != null || (ns = (type = individual.getRDFType()).getNameSpace()).equals("http://www.w3.org/2002/07/owl#") || type.equals((Object)RDF.List) || ns.equals(RDFS.getURI().toString()) || ns.equals(RDF.getURI().toString()) || type.canAs(OntClass.class) && ((OntClass)type.as(OntClass.class)).hasSuperClass(RDF.List)) continue;
            while (ontModel.getIndividual(name = String.valueOf(baseName) + index++) != null) {
            }
            Jena.renameResource(ontModel, (Resource)individual, name);
            JenaNormalizer.log("* Assigned name " + name + " to anonymous individual " + individual);
        }
    }

    private void assignNamesToAnonymousTopLevelClasses(OntModel ontModel, String defaultNamespace) {
        String baseName = String.valueOf(defaultNamespace) + "@";
        int index = 1;
        for (OntClass ontClass : Jena.set(JenaNormalizer.listAnonTopLevelClasses(ontModel))) {
            String name = String.valueOf(baseName) + index++;
            ResourceUtils.renameResource((Resource)ontClass, (String)name);
            JenaNormalizer.log("* Assigned name " + name + " to anonymous top-level class " + ontClass);
        }
    }

    public static void assignRDFTypesToMetaclassInstances(OntModel ontModel, Model owlFullModel) {
        int i = 0;
        boolean repeat = false;
        do {
            Set individuals = Jena.set((Iterator)ontModel.listIndividuals());
            repeat = false;
            for (Individual individual : individuals) {
                if (++i % 100 == 0) {
                    JenaNormalizer.log("- Assigning RDF types to individual " + i + " of " + individuals.size());
                }
                if (Jena.canAsOntClass((RDFNode)individual)) {
                    repeat = JenaNormalizer.ensureRDFType((OntResource)individual, OWL.Class, owlFullModel) || repeat;
                    continue;
                }
                if (Jena.canAsObjectProperty((RDFNode)individual)) {
                    repeat = JenaNormalizer.ensureRDFType((OntResource)individual, OWL.ObjectProperty, owlFullModel) || repeat;
                    continue;
                }
                if (!Jena.canAsDatatypeProperty((RDFNode)individual)) continue;
                boolean bl = repeat = JenaNormalizer.ensureRDFType((OntResource)individual, OWL.DatatypeProperty, owlFullModel) || repeat;
            }
        } while (repeat);
    }

    private void convertCyclicPropertyInheritance() {
        ArrayList errors = new ArrayList();
        this.convertCyclicPropertyInheritance(this.ontModel.listDatatypeProperties(), errors);
        this.convertCyclicPropertyInheritance(this.ontModel.listObjectProperties(), errors);
        if (errors.size() > 0) {
            for (Object o : errors) {
                System.err.println("[JenaNormalizer] " + o);
            }
        }
    }

    private void convertCyclicPropertyInheritance(ExtendedIterator it, List errors) {
        while (it.hasNext()) {
            OntProperty ontProperty = (OntProperty)it.next();
            try {
                this.convertCyclicPropertyInheritance(ontProperty, ontProperty, new HashSet(), errors);
            }
            catch (Throwable t) {
                System.out.println("Can't convertCyclicPropertyInheritance for " + ontProperty.getLocalName());
            }
        }
    }

    private void convertCyclicPropertyInheritance(OntProperty start, OntProperty ontProperty, Set visited, Collection errors) {
        visited.add(ontProperty);
        ExtendedIterator it = ontProperty.listSuperProperties(true);
        while (it.hasNext()) {
            OntProperty superProperty = (OntProperty)it.next();
            if (visited.contains(superProperty)) {
                errors.add("Error: Property " + ontProperty + " has a cyclic superproperty relation with " + superProperty + " - please use owl:equivalentProperty instead!");
                continue;
            }
            HashSet newSet = new HashSet(visited);
            this.convertCyclicPropertyInheritance(start, superProperty, newSet, errors);
        }
    }

    private void convertMultipleDomainsIntoIntersection(OntModel ontModel) {
        this.convertMultipleDomainsIntoIntersection((Iterator)ontModel.listDatatypeProperties());
        this.convertMultipleDomainsIntoIntersection((Iterator)ontModel.listObjectProperties());
    }

    private void convertMultipleDomainsIntoIntersection(Iterator ontProperties) {
        while (ontProperties.hasNext()) {
            OntProperty ontProperty = (OntProperty)ontProperties.next();
            Set domainSet = Jena.set((Iterator)ontProperty.listDomain());
            if (domainSet.size() <= 1) continue;
            JenaNormalizer.log("* Converted multiple domains for " + ontProperty.getLocalName() + " into an intersection class");
            RDFList list = this.ontModel.createList(domainSet.iterator());
            IntersectionClass intersectionClass = this.ontModel.createIntersectionClass(null, list);
            ontProperty.setDomain((Resource)intersectionClass);
        }
    }

    private void convertMultipleRangesIntoIntersection(OntModel ontModel) {
        this.convertMultipleRangesIntoIntersection((Iterator)ontModel.listObjectProperties());
    }

    private void convertMultipleRangesIntoIntersection(Iterator ontProperties) {
        while (ontProperties.hasNext()) {
            OntProperty ontProperty = (OntProperty)ontProperties.next();
            Set rangeSet = Jena.set((Iterator)ontProperty.listRange());
            if (rangeSet.size() <= 1) continue;
            RDFList list = this.ontModel.createList(rangeSet.iterator());
            IntersectionClass intersectionClass = this.ontModel.createIntersectionClass(null, list);
            ontProperty.setRange((Resource)intersectionClass);
            JenaNormalizer.log("* Converted multiple ranges for " + ontProperty.getLocalName() + " into an intersection class");
        }
    }

    private void convertNamedClassExpressions() {
        Set set = Jena.set((Iterator)this.ontModel.listNamedClasses());
        for (OntClass ontClass : set) {
            if (Jena.isSystemResource((Resource)ontClass)) continue;
            ComplementClass equivalentClass = null;
            if (ontClass.isComplementClass()) {
                equivalentClass = this.createComplementClass(ontClass.asComplementClass());
            } else if (ontClass.isEnumeratedClass()) {
                equivalentClass = this.createEnumeratedClass(ontClass);
            } else if (ontClass.isIntersectionClass()) {
                equivalentClass = this.createIntersectionClass(ontClass.asIntersectionClass());
            } else if (ontClass.isUnionClass()) {
                equivalentClass = this.createUnionClass(ontClass.asUnionClass());
            } else if (ontClass.isRestriction()) {
                equivalentClass = this.createRestriction(ontClass.asRestriction());
            }
            if (equivalentClass == null) continue;
            if (Jena.isImportedResource(this.ontModel, this.owlFullModel, (OntResource)ontClass)) {
                Graph homeGraph = Jena.getHomeGraph(this.ontModel, (OntResource)ontClass);
                homeGraph.add(new Triple(ontClass.asNode(), OWL.equivalentClass.getNode(), equivalentClass.getNode()));
                for (Statement statement : Jena.set((Iterator)equivalentClass.listProperties())) {
                    this.ontModel.remove(statement);
                    Node subject = statement.getSubject().getNode();
                    Node predicate = statement.getPredicate().getNode();
                    Node object = statement.getObject() == null ? null : statement.getObject().asNode();
                    Triple triple = new Triple(subject, predicate, object);
                    homeGraph.add(triple);
                    JenaNormalizer.log("  * Moved triple into imported graph: " + triple);
                }
                continue;
            }
            ontClass.addEquivalentClass((Resource)equivalentClass);
        }
    }

    private AllValuesFromRestriction createAllValuesFromRestriction(AllValuesFromRestriction base) {
        JenaNormalizer.log("+ Adding anonymous AllValuesFromRestriction for " + base);
        AllValuesFromRestriction result = this.ontModel.createAllValuesFromRestriction(null, (Property)base.getOnProperty(), base.getAllValuesFrom());
        base.removeAll(this.ontModel.getProfile().ALL_VALUES_FROM());
        base.removeAll(this.ontModel.getProfile().ON_PROPERTY());
        return result;
    }

    private CardinalityRestriction createCardinalityRestriction(CardinalityRestriction base) {
        JenaNormalizer.log("+ Adding anonymous OWLCardinalityBase for " + base);
        CardinalityRestriction result = this.ontModel.createCardinalityRestriction(null, (Property)base.getOnProperty(), base.getCardinality());
        base.removeAll(this.ontModel.getProfile().CARDINALITY());
        base.removeAll(this.ontModel.getProfile().ON_PROPERTY());
        return result;
    }

    private ComplementClass createComplementClass(ComplementClass base) {
        JenaNormalizer.log("+ Adding anonymous ComplementClass for " + base);
        OntClass operand = base.getOperand();
        base.removeAll(this.ontModel.getProfile().COMPLEMENT_OF());
        return this.ontModel.createComplementClass(null, (Resource)operand);
    }

    private EnumeratedClass createEnumeratedClass(OntClass enumeratedClass) {
        JenaNormalizer.log("+ Adding anonymous EnumeratedClass for " + enumeratedClass);
        Property oneOfProperty = this.ontModel.getProperty(OWL.oneOf.getURI());
        Statement s = enumeratedClass.getProperty(oneOfProperty);
        RDFList members = (RDFList)s.getObject().as(RDFList.class);
        this.ontModel.remove(s);
        return this.ontModel.createEnumeratedClass(null, members);
    }

    private HasValueRestriction createHasValueRestriction(HasValueRestriction base) {
        JenaNormalizer.log("+ Adding anonymous HasValueRestriction for " + base);
        HasValueRestriction result = this.ontModel.createHasValueRestriction(null, (Property)base.getOnProperty(), base.getHasValue());
        base.removeAll(this.ontModel.getProfile().HAS_VALUE());
        base.removeAll(this.ontModel.getProfile().ON_PROPERTY());
        return result;
    }

    private IntersectionClass createIntersectionClass(IntersectionClass intersectionClass) {
        JenaNormalizer.log("+ Adding anonymous IntersectionClass for " + intersectionClass);
        RDFList operands = intersectionClass.getOperands();
        IntersectionClass result = this.ontModel.createIntersectionClass(null, operands);
        intersectionClass.removeAll(this.ontModel.getProfile().INTERSECTION_OF());
        return result;
    }

    private MaxCardinalityRestriction createMaxCardinalityRestriction(MaxCardinalityRestriction base) {
        JenaNormalizer.log("+ Adding anonymous MaxCardinalityRestriction for " + base);
        MaxCardinalityRestriction result = this.ontModel.createMaxCardinalityRestriction(null, (Property)base.getOnProperty(), base.getMaxCardinality());
        base.removeAll(this.ontModel.getProfile().CARDINALITY());
        base.removeAll(this.ontModel.getProfile().ON_PROPERTY());
        return result;
    }

    private MinCardinalityRestriction createMinCardinalityRestriction(MinCardinalityRestriction base) {
        JenaNormalizer.log("+ Adding anonymous MinCardinalityRestriction for " + base);
        MinCardinalityRestriction result = this.ontModel.createMinCardinalityRestriction(null, (Property)base.getOnProperty(), base.getMinCardinality());
        base.removeAll(this.ontModel.getProfile().CARDINALITY());
        base.removeAll(this.ontModel.getProfile().ON_PROPERTY());
        return result;
    }

    private Restriction createRestriction(Restriction restriction) {
        if (restriction.isAllValuesFromRestriction()) {
            return this.createAllValuesFromRestriction(restriction.asAllValuesFromRestriction());
        }
        if (restriction.isSomeValuesFromRestriction()) {
            return this.createSomeValuesFromRestriction(restriction.asSomeValuesFromRestriction());
        }
        if (restriction.isHasValueRestriction()) {
            return this.createHasValueRestriction(restriction.asHasValueRestriction());
        }
        if (restriction.isMaxCardinalityRestriction()) {
            return this.createMaxCardinalityRestriction(restriction.asMaxCardinalityRestriction());
        }
        if (restriction.isMinCardinalityRestriction()) {
            return this.createMinCardinalityRestriction(restriction.asMinCardinalityRestriction());
        }
        if (restriction.isCardinalityRestriction()) {
            return this.createCardinalityRestriction(restriction.asCardinalityRestriction());
        }
        return null;
    }

    private SomeValuesFromRestriction createSomeValuesFromRestriction(SomeValuesFromRestriction base) {
        JenaNormalizer.log("+ Adding anonymous SomeValuesFromRestriction for " + base);
        SomeValuesFromRestriction result = this.ontModel.createSomeValuesFromRestriction(null, (Property)base.getOnProperty(), base.getSomeValuesFrom());
        base.removeAll(this.ontModel.getProfile().SOME_VALUES_FROM());
        base.removeAll(this.ontModel.getProfile().ON_PROPERTY());
        return result;
    }

    private UnionClass createUnionClass(UnionClass unionClass) {
        JenaNormalizer.log("+ Adding anonymous UnionClass for " + unionClass);
        RDFList operands = unionClass.getOperands();
        unionClass.removeAll(this.ontModel.getProfile().UNION_OF());
        return this.ontModel.createUnionClass(null, operands);
    }

    private void ensureAnnotationPropertiesHaveRange() {
        for (AnnotationProperty annotationProperty : Jena.set((Iterator)this.ontModel.listAnnotationProperties())) {
            String ns;
            if (annotationProperty.canAs(DatatypeProperty.class) || annotationProperty.canAs(ObjectProperty.class) || (ns = annotationProperty.getNameSpace()).equals("http://www.w3.org/2002/07/owl#") || ns.equals(RDFS.getURI())) continue;
            Graph graph = this.ontModel.getGraph();
            if (Jena.isImportedResource(this.ontModel, this.owlFullModel, (OntResource)annotationProperty)) {
                graph = this.getHomeGraph((OntResource)annotationProperty);
            }
            graph.add(new Triple(annotationProperty.getNode(), RDF.type.getNode(), OWL.DatatypeProperty.getNode()));
            XSDDatatype datatype = XSDDatatype.XSDstring;
            if (annotationProperty.getURI().equals(String.valueOf(ProtegeNames.NS) + "readOnly")) {
                datatype = XSDDatatype.XSDboolean;
            }
            graph.add(new Triple(annotationProperty.getNode(), RDFS.range.getNode(), this.ontModel.getResource(datatype.getURI()).getNode()));
            JenaNormalizer.log("Made annotationProperty " + annotationProperty.getURI() + " a datatype property with range " + datatype);
        }
    }

    private static boolean ensureRDFType(OntResource individual, Resource type, Model owlFullModel) {
        if (!individual.hasRDFType(type)) {
            owlFullModel.add((Resource)individual, RDF.type, (RDFNode)type);
            JenaNormalizer.log("+ Added " + type + " to rdf:types of " + individual + " in OWL Full model");
            return true;
        }
        return false;
    }

    private Graph getHomeGraph(OntResource resource) {
        Property predicate = RDF.type;
        Resource object = resource.getRDFType();
        for (Graph graph : this.ontModel.getSubGraphs()) {
            if (!graph.contains(resource.getNode(), predicate.getNode(), object.getNode())) continue;
            return graph;
        }
        return null;
    }

    public static Iterator listAnonTopLevelClasses(OntModel m) {
        final Set objects = Jena.set((Iterator)m.listObjects());
        return m.listClasses().filterDrop(new Filter(){

            public boolean accept(Object x) {
                OntClass c = (OntClass)x;
                return !c.isAnon() || objects.contains(c);
            }
        });
    }

    private static void log(String message) {
        if (logging) {
            System.out.println("[JenaNormalizer]  " + message);
        }
    }

    private void mergeOntologies() {
        ExtendedIterator it = this.ontModel.listOntologies();
        while (it.hasNext()) {
            Ontology ontology = (Ontology)it.next();
            if (ontology.getURI() != null) continue;
            System.err.println("Warning: Ontology without URI detected: The correct syntax is <owl:Ontology rdf:about=\"\"> and there should be a default namespace");
        }
    }

    private void removeRedundantDomains(Iterator it) {
        while (it.hasNext()) {
            OntProperty ontProperty = (OntProperty)it.next();
            Set domain = Jena.set((Iterator)ontProperty.listDomain());
            if (!domain.contains(OWL.Thing)) continue;
            ontProperty.removeAll(RDFS.domain);
            JenaNormalizer.log("- Removed redundant domain from property " + ontProperty);
        }
    }

    private static Resource setResourceNamespace(Resource resource, String newNamespace) {
        String cmp = String.valueOf(newNamespace) + "#";
        if (!Jena.isSystemResource(resource) && !cmp.equals(resource.getNameSpace())) {
            String localName = resource.getLocalName();
            if (!AbstractOWLModel.isValidOWLFrameName(null, localName)) {
                localName = "_" + localName;
            }
            String newURI = String.valueOf(Jena.isNamespaceWithSeparator(newNamespace) ? newNamespace : cmp) + localName;
            JenaNormalizer.log("* Namespacing " + resource.getURI() + " to " + newURI);
            return ResourceUtils.renameResource((Resource)resource, (String)newURI);
        }
        return null;
    }

    public static void standardizePrefixes(OntModel ontModel) {
        ontModel.setNsPrefix("owl", "http://www.w3.org/2002/07/owl#");
    }

    public static void unifyNamespace(OntModel ontModel, String oldNamespace, String newNamespace) {
        if (!oldNamespace.equals(newNamespace)) {
            JenaNormalizer.unifyNamespaceOfOntologies(ontModel, oldNamespace, newNamespace);
            JenaNormalizer.unifyNamespaceOfProperties(ontModel, oldNamespace, newNamespace);
            JenaNormalizer.unifyNamespaceOfNamedClasses(ontModel, oldNamespace, newNamespace);
            JenaNormalizer.unifyNamespaceOfIndividuals(ontModel, oldNamespace, newNamespace);
        }
    }

    private static void unifyNamespaceOfIndividuals(OntModel ontModel, String oldNamespace, String newNamespace) {
        Set individuals = Jena.set((Iterator)ontModel.listIndividuals());
        JenaNormalizer.unifyNamespaceOfResources(individuals.iterator(), oldNamespace, newNamespace);
        JenaNormalizer.unifyNamespaceOfResources((Iterator)ontModel.listObjects(), oldNamespace, newNamespace);
    }

    private static void unifyNamespaceOfResources(Iterator it, String oldNamespace, String newNamespace) {
        while (it.hasNext()) {
            Individual resource;
            String namespace;
            Object next = it.next();
            if (!(next instanceof Resource) || !((Resource)next).canAs(Individual.class) || (namespace = (resource = (Individual)((Resource)next).as(Individual.class)).getNameSpace()) == null || oldNamespace != null && !namespace.equals(oldNamespace)) continue;
            JenaNormalizer.setResourceNamespace((Resource)resource, newNamespace);
        }
    }

    private static void unifyNamespaceOfNamedClasses(OntModel ontModel, String oldNamespace, String newNamespace) {
        Set namedClasses = Jena.set((Iterator)ontModel.listNamedClasses());
        for (OntClass ontClass : namedClasses) {
            if (oldNamespace != null && !ontClass.getNameSpace().equals(oldNamespace)) continue;
            JenaNormalizer.setResourceNamespace((Resource)ontClass, newNamespace);
        }
    }

    private static void unifyNamespaceOfOntologies(OntModel ontModel, String oldNamespace, String newNamespace) {
        Set ontologies = Jena.set((Iterator)ontModel.listOntologies());
        for (Ontology ontology : ontologies) {
            String ontologyNS;
            String uri = ontology.getURI();
            if (uri == null) continue;
            String string = ontologyNS = Jena.isNamespaceWithSeparator(uri) ? uri : String.valueOf(uri) + "#";
            if (!ontologyNS.equals(oldNamespace)) continue;
            String newURI = newNamespace;
            if (newURI.endsWith("#")) {
                newURI = newNamespace.substring(0, newNamespace.length() - 1);
            }
            JenaNormalizer.log("* Renaming ontology " + ontology.getURI() + " into namespace " + newURI);
            ResourceUtils.renameResource((Resource)ontology, (String)newURI);
        }
    }

    private static void unifyNamespaceOfProperties(OntModel ontModel, String oldNamespace, String newNamespace) {
        Set properties = Jena.set((Iterator)ontModel.listDatatypeProperties());
        Jena.set(properties, (Iterator)ontModel.listObjectProperties());
        Jena.set(properties, (Iterator)ontModel.listAnnotationProperties());
        for (Property ontProperty : properties) {
            Resource renamed;
            if (oldNamespace != null && !ontProperty.getNameSpace().equals(oldNamespace) || (renamed = JenaNormalizer.setResourceNamespace((Resource)ontProperty, newNamespace)) == null) continue;
            Property newProperty = (Property)renamed.as(Property.class);
            Set statements = Jena.set((Iterator)ontModel.listStatements(null, ontProperty, null));
            for (Statement s : statements) {
                s.remove();
                ontModel.add(s.getSubject(), newProperty, s.getObject());
                JenaNormalizer.log("* Changed statement (" + s.getSubject() + ", " + newProperty + ", " + s.getObject());
            }
        }
    }

    private static void updateLoggingStatus() {
        String str = ApplicationProperties.getString((String)LOGGING, (String)"false");
        logging = str != null && str.equalsIgnoreCase("true");
    }
}

