/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.creator.tests;

import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.rdf.model.Property;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protegex.owl.jena.Jena;
import edu.stanford.smi.protegex.owl.jena.creator.tests.AbstractJenaCreatorTestCase;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;

public class CreateIndividualsTestCase
extends AbstractJenaCreatorTestCase {
    public void testCreateInstance() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Cls");
        RDFResource instance = cls.createInstance("individual");
        OntModel newModel = this.runJenaCreator();
        Individual individual = newModel.getIndividual(instance.getURI());
        CreateIndividualsTestCase.assertNotNull((Object)individual);
    }

    public void testCreatePropertyValues() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Cls");
        OWLObjectProperty objectSlot = this.owlModel.createOWLObjectProperty("object");
        objectSlot.setUnionRangeClasses(Collections.singleton(cls));
        objectSlot.addUnionDomainClass(cls);
        OWLDatatypeProperty datatypeSlot = this.owlModel.createOWLDatatypeProperty("datatype");
        datatypeSlot.addUnionDomainClass(cls);
        RDFResource instance = cls.createInstance("individual");
        instance.setPropertyValue(objectSlot, instance);
        instance.setPropertyValues(datatypeSlot, Arrays.asList("A", "B"));
        OntModel newModel = this.runJenaCreator();
        Individual individual = newModel.getIndividual(instance.getURI());
        CreateIndividualsTestCase.assertNotNull((Object)individual);
        OntProperty datatypeProperty = newModel.getOntProperty(datatypeSlot.getURI());
        OntProperty objectProperty = newModel.getOntProperty(objectSlot.getURI());
        CreateIndividualsTestCase.assertEquals((Object)individual, (Object)individual.getPropertyValue((Property)objectProperty));
        Set values = Jena.set((Iterator)individual.listPropertyValues((Property)datatypeProperty));
        CreateIndividualsTestCase.assertSize(2, values);
        CreateIndividualsTestCase.assertHasValue((OntResource)individual, datatypeProperty, ValueType.STRING, "A");
        CreateIndividualsTestCase.assertHasValue((OntResource)individual, datatypeProperty, ValueType.STRING, "B");
    }

    public void testCreateIndividualWithInferredTypes() {
        OWLNamedClass clsA = this.owlModel.createOWLNamedClass("A");
        OWLNamedClass clsB = this.owlModel.createOWLNamedClass("B");
        OWLNamedClass clsC = this.owlModel.createOWLNamedClass("C");
        RDFResource instance = clsA.createInstance("instance");
        instance.addOwnSlotValue(this.owlModel.getSlot("protege:inferredType"), clsB);
        instance.addOwnSlotValue(this.owlModel.getSlot("protege:inferredType"), clsC);
        OntModel newModel = this.runJenaCreator(false, true);
        Individual individual = newModel.getIndividual(instance.getURI());
        OntClass classB = newModel.getOntClass(clsB.getURI());
        OntClass classC = newModel.getOntClass(clsC.getURI());
        CreateIndividualsTestCase.assertSize(2, (Iterator)individual.listRDFTypes(true));
        CreateIndividualsTestCase.assertContains((Object)classB, (Iterator)individual.listRDFTypes(true));
        CreateIndividualsTestCase.assertContains((Object)classC, (Iterator)individual.listRDFTypes(true));
    }

    public void testCreateInstanceOfOWLThing() {
        OWLIndividual individual = this.owlThing.createOWLIndividual("Test");
        OntModel newModel = this.runJenaCreator();
        Individual indi = newModel.getIndividual(individual.getURI());
        CreateIndividualsTestCase.assertNotNull((Object)indi);
    }

    public void testCreateIndividualsChain() {
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        OWLIndividual a = this.owlThing.createOWLIndividual("a");
        OWLIndividual b = this.owlThing.createOWLIndividual("b");
        OWLIndividual c = this.owlThing.createOWLIndividual("c");
        a.setPropertyValue(property, b);
        b.setPropertyValue(property, c);
        OntModel newModel = this.runJenaCreator(false);
        Individual ontA = newModel.getIndividual(a.getURI());
        Individual ontB = newModel.getIndividual(b.getURI());
        Individual ontC = newModel.getIndividual(c.getURI());
        OntProperty ontProperty = newModel.getOntProperty(property.getURI());
        CreateIndividualsTestCase.assertSize(1, (Iterator)ontA.listPropertyValues((Property)ontProperty));
        CreateIndividualsTestCase.assertEquals((Object)ontB, (Object)ontA.getPropertyValue((Property)ontProperty));
        CreateIndividualsTestCase.assertSize(1, (Iterator)ontB.listPropertyValues((Property)ontProperty));
        CreateIndividualsTestCase.assertSize(0, (Iterator)ontC.listPropertyValues((Property)ontProperty));
    }
}

