/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.parser.tests;

import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;

public class LoadMetaclassesTestCase
extends AbstractJenaTestCase {
    public void testLoadMetaclassInstances() throws Exception {
        this.loadRemoteOntology("metaclasses.owl");
        OWLNamedClass a = this.owlModel.getOWLNamedClass("A");
        LoadMetaclassesTestCase.assertSize(1, a.getSuperclasses(false));
        LoadMetaclassesTestCase.assertContains((Object)this.owlModel.getOWLNamedClassClass(), a.getSuperclasses(false));
        OWLNamedClass b = this.owlModel.getOWLNamedClass("B");
        LoadMetaclassesTestCase.assertSize(1, b.getSuperclasses(false));
        LoadMetaclassesTestCase.assertContains((Object)a, b.getSuperclasses(false));
        OWLNamedClass instanceClsA = this.owlModel.getOWLNamedClass("InstanceClsA");
        LoadMetaclassesTestCase.assertSize(1, instanceClsA.getProtegeTypes());
        LoadMetaclassesTestCase.assertContains((Object)a, instanceClsA.getProtegeTypes());
        OWLNamedClass instanceClsB = this.owlModel.getOWLNamedClass("InstanceClsB");
        LoadMetaclassesTestCase.assertSize(1, instanceClsB.getProtegeTypes());
        LoadMetaclassesTestCase.assertContains((Object)b, instanceClsB.getProtegeTypes());
    }

    public void testLoadRDFMetaclass() throws Exception {
        this.loadRemoteOntology("rdfmetaclassbug.owl");
        RDFSNamedClass aClass = this.owlModel.getRDFSNamedClass("Class_01");
        LoadMetaclassesTestCase.assertNotNull((Object)aClass);
        aClass.setDirectOwnSlotValue(this.owlModel.getSlot("rdfs:comment"), "comment");
    }

    public void testLoadMyGeneric() throws Exception {
        this.loadRemoteOntology("mygeneric.owl");
    }

    public void testLoadRecursiveMetaclass() throws Exception {
        OWLNamedClass oldClass = this.owlModel.createOWLNamedSubclass("Metaclass", this.owlModel.getOWLNamedClassClass());
        oldClass.setRDFType(oldClass);
        JenaOWLModel newModel = LoadMetaclassesTestCase.reload(this.owlModel);
        OWLNamedClass newClass = newModel.getOWLNamedClass(oldClass.getName());
        LoadMetaclassesTestCase.assertSize(1, newClass.getRDFTypes());
        LoadMetaclassesTestCase.assertEquals((Object)newClass, (Object)newClass.getRDFType());
    }
}

